/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateParser;
import org.junit.Assert;
import org.junit.Test;

public class FastDateParser_TimeZoneStrategyTest {
    @Test
    public void testTimeZoneStrategyPattern() {
        for (Locale locale : Locale.getAvailableLocales()) {
            String[][] zones;
            FastDateParser parser = new FastDateParser("z", TimeZone.getDefault(), locale);
            for (String[] zone : zones = DateFormatSymbols.getInstance(locale).getZoneStrings()) {
                String tzDisplay;
                for (int t = 1; t < zone.length && (tzDisplay = zone[t]) != null; ++t) {
                    try {
                        parser.parse(tzDisplay);
                        continue;
                    }
                    catch (Exception ex) {
                        Assert.fail((String)("'" + tzDisplay + "'" + " Locale: '" + locale.getDisplayName() + "'" + " TimeZone: " + zone[0] + " offset: " + t + " defaultLocale: " + Locale.getDefault() + " defaultTimeZone: " + TimeZone.getDefault().getDisplayName()));
                    }
                }
            }
        }
    }

    @Test
    public void testLang1219() throws ParseException {
        FastDateParser parser = new FastDateParser("dd.MM.yyyy HH:mm:ss z", TimeZone.getDefault(), Locale.GERMAN);
        Date summer = parser.parse("26.10.2014 02:00:00 MESZ");
        Date standard = parser.parse("26.10.2014 02:00:00 MEZ");
        Assert.assertNotEquals((long)summer.getTime(), (long)standard.getTime());
    }
}

