/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ToStringBuilderTest {
    private static final int ARRAYLIST_INITIAL_CAPACITY = 10;
    private final Integer base = 5;
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    @After
    public void after() {
        this.validateNullToStringStyleRegistry();
    }

    @Test
    public void testConstructorEx1() {
        Assert.assertEquals((Object)"<null>", (Object)new ToStringBuilder(null).toString());
    }

    @Test
    public void testConstructorEx2() {
        Assert.assertEquals((Object)"<null>", (Object)new ToStringBuilder(null, null).toString());
        new ToStringBuilder((Object)this.base, null).toString();
    }

    @Test
    public void testConstructorEx3() {
        Assert.assertEquals((Object)"<null>", (Object)new ToStringBuilder(null, null, null).toString());
        new ToStringBuilder((Object)this.base, null, null).toString();
        new ToStringBuilder((Object)this.base, ToStringStyle.DEFAULT_STYLE, null).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSetDefault() {
        try {
            ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.NO_FIELD_NAMES_STYLE);
            Assert.assertSame((Object)ToStringStyle.NO_FIELD_NAMES_STYLE, (Object)ToStringBuilder.getDefaultStyle());
        }
        finally {
            ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetDefaultEx() {
        ToStringBuilder.setDefaultStyle(null);
    }

    @Test
    public void testBlank() {
        Assert.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testReflectionInteger() {
        Assert.assertEquals((Object)(this.baseStr + "[value=5]"), (Object)ToStringBuilder.reflectionToString((Object)this.base));
    }

    @Test
    public void testReflectionCharacter() {
        Character c = new Character('A');
        Assert.assertEquals((Object)(this.toBaseString(c) + "[value=A]"), (Object)ToStringBuilder.reflectionToString((Object)c));
    }

    @Test
    public void testReflectionBoolean() {
        Boolean b = Boolean.TRUE;
        Assert.assertEquals((Object)(this.toBaseString(b) + "[value=true]"), (Object)ToStringBuilder.reflectionToString((Object)b));
        b = Boolean.FALSE;
        Assert.assertEquals((Object)(this.toBaseString(b) + "[value=false]"), (Object)ToStringBuilder.reflectionToString((Object)b));
    }

    private String toBaseString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public void assertReflectionArray(String expected, Object actual) {
        if (actual == null) {
            return;
        }
        Assert.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual));
        Assert.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual, null));
        Assert.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual, null, (boolean)true));
        Assert.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual, null, (boolean)false));
    }

    @Test
    public void testReflectionObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{<null>,5,{3,6}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionIntArray() {
        int[] array = new int[]{1, 2, -3, 4};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionShortArray() {
        short[] array = new short[]{1, 2, -3, 4};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionyteArray() {
        byte[] array = new byte[]{1, 2, -3, 4};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionCharArray() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{A,2,_,D}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionDoubleArray() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionFloatArray() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionBooleanArray() {
        boolean[] array = new boolean[]{true, false, false};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{true,false,false}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionFloatArrayArray() {
        Object array = new float[][]{{1.0f, 2.29686f}, null, {Float.NaN}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionIntArrayArray() {
        Object array = new int[][]{{1, 2}, null, {5}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionhortArrayArray() {
        Object array = new short[][]{{1, 2}, null, {5}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionByteArrayArray() {
        Object array = new byte[][]{{1, 2}, null, {5}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionCharArrayArray() {
        Object array = new char[][]{{'A', 'B'}, null, {'p'}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{A,B},<null>,{p}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionDoubleArrayArray() {
        Object array = new double[][]{{1.0, 2.29686}, null, {Double.NaN}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionBooleanArrayArray() {
        Object array = new boolean[][]{{true, false}, null, {false}};
        String baseString = this.toBaseString(array);
        Assert.assertEquals((Object)(baseString + "[{{true,false},<null>,{false}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        Assert.assertEquals((Object)(baseString + "[{{true,false},<null>,{false}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    public void testReflectionHierarchyArrayList() {
        String toStringWithoutTransients;
        String expectedWithoutTransients;
        Assume.assumeFalse(("IBM Corporation".equals(SystemUtils.JAVA_VENDOR) && "1.6".equals(SystemUtils.JAVA_SPECIFICATION_VERSION) ? 1 : 0) != 0);
        Assume.assumeFalse(("Oracle Corporation".equals(SystemUtils.JAVA_VENDOR) && "1.6".compareTo(SystemUtils.JAVA_SPECIFICATION_VERSION) < 0 ? 1 : 0) != 0);
        ArrayList list = new ArrayList(10);
        String baseString = this.toBaseString(list);
        String expectedWithTransients = baseString + "[elementData={<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>},size=0,modCount=0]";
        String toStringWithTransients = ToStringBuilder.reflectionToString(list, null, (boolean)true);
        if (!expectedWithTransients.equals(toStringWithTransients)) {
            Assert.assertEquals((Object)expectedWithTransients, (Object)toStringWithTransients);
        }
        if (!(expectedWithoutTransients = baseString + "[size=0]").equals(toStringWithoutTransients = ToStringBuilder.reflectionToString(list, null, (boolean)false))) {
            Assert.assertEquals((Object)expectedWithoutTransients, (Object)toStringWithoutTransients);
        }
    }

    @Test
    public void testReflectionHierarchy() {
        ReflectionTestFixtureA baseA = new ReflectionTestFixtureA();
        String baseString = this.toBaseString(baseA);
        Assert.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA));
        Assert.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null));
        Assert.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false));
        Assert.assertEquals((Object)(baseString + "[a=a,transientA=t]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)true));
        Assert.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, null));
        Assert.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, Object.class));
        Assert.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, ReflectionTestFixtureA.class));
        ReflectionTestFixtureB baseB = new ReflectionTestFixtureB();
        baseString = this.toBaseString(baseB);
        Assert.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB));
        Assert.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB));
        Assert.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null));
        Assert.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false));
        Assert.assertEquals((Object)(baseString + "[b=b,transientB=t,a=a,transientA=t]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)true));
        Assert.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, null));
        Assert.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, Object.class));
        Assert.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, ReflectionTestFixtureA.class));
        Assert.assertEquals((Object)(baseString + "[b=b]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, ReflectionTestFixtureB.class));
    }

    @Test
    public void testInnerClassReflection() {
        Outer outer = new Outer();
        Assert.assertEquals((Object)(this.toBaseString(outer) + "[inner=" + this.toBaseString(outer.inner) + "[]]"), (Object)outer.toString());
    }

    @Test
    public void testReflectionArrayCycle() {
        Object[] objects;
        objects[0] = objects = new Object[1];
        Assert.assertEquals((Object)(this.toBaseString(objects) + "[{" + this.toBaseString(objects) + "}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
    }

    @Test
    public void testReflectionArrayCycleLevel2() {
        Object[] objectsLevel2 = new Object[1];
        Object[] objects = new Object[]{objectsLevel2};
        objectsLevel2[0] = objects;
        Assert.assertEquals((Object)(this.toBaseString(objects) + "[{{" + this.toBaseString(objects) + "}}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
        Assert.assertEquals((Object)(this.toBaseString(objectsLevel2) + "[{{" + this.toBaseString(objectsLevel2) + "}}]"), (Object)ToStringBuilder.reflectionToString((Object)objectsLevel2));
    }

    @Test
    public void testReflectionArrayArrayCycle() throws Exception {
        Object[][] objects;
        objects[0][0] = objects = new Object[2][2];
        objects[0][1] = objects;
        objects[1][0] = objects;
        objects[1][1] = objects;
        String basicToString = this.toBaseString(objects);
        Assert.assertEquals((Object)(basicToString + "[{{" + basicToString + "," + basicToString + "},{" + basicToString + "," + basicToString + "}}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
    }

    @Test
    public void testSimpleReflectionObjectCycle() {
        SimpleReflectionTestFixture simple = new SimpleReflectionTestFixture();
        simple.o = simple;
        Assert.assertEquals((Object)(this.toBaseString(simple) + "[o=" + this.toBaseString(simple) + "]"), (Object)simple.toString());
    }

    @Test
    public void testSelfInstanceVarReflectionObjectCycle() {
        SelfInstanceVarReflectionTestFixture test = new SelfInstanceVarReflectionTestFixture();
        Assert.assertEquals((Object)(this.toBaseString(test) + "[typeIsSelf=" + this.toBaseString(test) + "]"), (Object)test.toString());
    }

    @Test
    public void testSelfInstanceTwoVarsReflectionObjectCycle() {
        SelfInstanceTwoVarsReflectionTestFixture test = new SelfInstanceTwoVarsReflectionTestFixture();
        Assert.assertEquals((Object)(this.toBaseString(test) + "[typeIsSelf=" + this.toBaseString(test) + ",otherType=" + test.getOtherType().toString() + "]"), (Object)test.toString());
    }

    @Test
    public void testReflectionObjectCycle() {
        ReflectionTestCycleB b;
        ReflectionTestCycleA a = new ReflectionTestCycleA();
        a.b = b = new ReflectionTestCycleB();
        b.a = a;
        Assert.assertEquals((Object)(this.toBaseString(a) + "[b=" + this.toBaseString(b) + "[a=" + this.toBaseString(a) + "]]"), (Object)a.toString());
    }

    @Test
    public void testReflectionArrayAndObjectCycle() {
        Object[] objects = new Object[1];
        SimpleReflectionTestFixture simple = new SimpleReflectionTestFixture(objects);
        objects[0] = simple;
        Assert.assertEquals((Object)(this.toBaseString(objects) + "[{" + this.toBaseString(simple) + "[o=" + this.toBaseString(objects) + "]" + "}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
        Assert.assertEquals((Object)(this.toBaseString(simple) + "[o={" + this.toBaseString(simple) + "}]"), (Object)ToStringBuilder.reflectionToString((Object)simple));
    }

    void validateNullToStringStyleRegistry() {
        Map registry = ToStringStyle.getRegistry();
        Assert.assertNull((String)("Expected null, actual: " + registry), (Object)registry);
    }

    @Test
    public void testAppendSuper() {
        Assert.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>,a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testAppendToString() {
        Assert.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[<null>]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>,a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendToString(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testAppendAsObjectToString() {
        String objectToAppend1 = "";
        Boolean objectToAppend2 = Boolean.TRUE;
        Object objectToAppend3 = new Object();
        Assert.assertEquals((Object)(this.baseStr + "[" + this.toBaseString("") + "]"), (Object)new ToStringBuilder((Object)this.base).appendAsObjectToString((Object)"").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + this.toBaseString(objectToAppend2) + "]"), (Object)new ToStringBuilder((Object)this.base).appendAsObjectToString((Object)objectToAppend2).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + this.toBaseString(objectToAppend3) + "]"), (Object)new ToStringBuilder((Object)this.base).appendAsObjectToString(objectToAppend3).toString());
    }

    @Test
    public void testAppendBooleanArrayWithFieldName() {
        boolean[] array = new boolean[]{true, false, false};
        Assert.assertEquals((Object)(this.baseStr + "[flags={true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append("flags", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendBooleanArrayWithFieldNameAndFullDetatil() {
        boolean[] array = new boolean[]{true, false, false};
        Assert.assertEquals((Object)(this.baseStr + "[flags={true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append("flags", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendCharArrayWithFieldName() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        Assert.assertEquals((Object)(this.baseStr + "[chars={A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append("chars", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[letters={A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append("letters", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendCharArrayWithFieldNameAndFullDetatil() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        Assert.assertEquals((Object)(this.baseStr + "[chars={A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append("chars", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[letters=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("letters", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendDoubleArrayWithFieldName() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        Assert.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendDoubleArrayWithFieldNameAndFullDetatil() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        Assert.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendObjectArrayWithFieldName() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assert.assertEquals((Object)(this.baseStr + "[values={<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendObjectArrayWithFieldNameAndFullDetatil() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assert.assertEquals((Object)(this.baseStr + "[values={<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendLongArrayWithFieldName() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendLongArrayWithFieldNameAndFullDetatil() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendIntArrayWithFieldName() {
        int[] array = new int[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendIntArrayWithFieldNameAndFullDetatil() {
        int[] array = new int[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendShortArrayWithFieldName() {
        short[] array = new short[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendShortArrayWithFieldNameAndFullDetatil() {
        short[] array = new short[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendByteArrayWithFieldName() {
        byte[] array = new byte[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendByteArrayWithFieldNameAndFullDetatil() {
        byte[] array = new byte[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testAppendFloatArrayWithFieldName() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        Assert.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    public void testAppendFloatArrayWithFieldNameAndFullDetatil() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        Assert.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    public void testConstructToStringBuilder() {
        ToStringBuilder stringBuilder1 = new ToStringBuilder((Object)this.base, null, null);
        ToStringBuilder stringBuilder2 = new ToStringBuilder((Object)this.base, ToStringStyle.DEFAULT_STYLE, new StringBuffer(1024));
        Assert.assertEquals((Object)ToStringStyle.DEFAULT_STYLE, (Object)stringBuilder1.getStyle());
        Assert.assertNotNull((Object)stringBuilder1.getStringBuffer());
        Assert.assertNotNull((Object)stringBuilder1.toString());
        Assert.assertEquals((Object)ToStringStyle.DEFAULT_STYLE, (Object)stringBuilder2.getStyle());
        Assert.assertNotNull((Object)stringBuilder2.getStringBuffer());
        Assert.assertNotNull((Object)stringBuilder2.toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=<Integer>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=[]]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    @Test
    public void testObjectBuild() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)null).build());
        Assert.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((Object)i3).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)null).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=<Integer>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=[]]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).build());
        Assert.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).build());
        Assert.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).build());
        Assert.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).build());
    }

    @Test
    public void testLong() {
        Assert.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testInt() {
        Assert.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append(3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3).append("b", 4).toString());
    }

    @Test
    public void testShort() {
        Assert.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((short)3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (short)3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (short)3).append("b", (short)4).toString());
    }

    @Test
    public void testChar() {
        Assert.assertEquals((Object)(this.baseStr + "[A]"), (Object)new ToStringBuilder((Object)this.base).append('A').toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=A]"), (Object)new ToStringBuilder((Object)this.base).append("a", 'A').toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=A,b=B]"), (Object)new ToStringBuilder((Object)this.base).append("a", 'A').append("b", 'B').toString());
    }

    @Test
    public void testByte() {
        Assert.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((byte)3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (byte)3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (byte)3).append("b", (byte)4).toString());
    }

    @Test
    public void testDouble() {
        Assert.assertEquals((Object)(this.baseStr + "[3.2]"), (Object)new ToStringBuilder((Object)this.base).append(3.2).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3.2]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3.2,b=4.3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2).append("b", 4.3).toString());
    }

    @Test
    public void testFloat() {
        Assert.assertEquals((Object)(this.baseStr + "[3.2]"), (Object)new ToStringBuilder((Object)this.base).append(3.2f).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3.2]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2f).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=3.2,b=4.3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2f).append("b", 4.3f).toString());
    }

    @Test
    public void testBoolean() {
        Assert.assertEquals((Object)(this.baseStr + "[true]"), (Object)new ToStringBuilder((Object)this.base).append(true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=true]"), (Object)new ToStringBuilder((Object)this.base).append("a", true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[a=true,b=false]"), (Object)new ToStringBuilder((Object)this.base).append("a", true).append("b", false).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assert.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testIntArray() {
        int[] array = new int[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testShortArray() {
        short[] array = new short[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testByteArray() {
        byte[] array = new byte[]{1, 2, -3, 4};
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testCharArray() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        Assert.assertEquals((Object)(this.baseStr + "[{A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testDoubleArray() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        Assert.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testFloatArray() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        Assert.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testBooleanArray() {
        boolean[] array = new boolean[]{true, false, false};
        Assert.assertEquals((Object)(this.baseStr + "[{true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testIntArrayArray() {
        Object array = new int[][]{{1, 2}, null, {5}};
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testShortArrayArray() {
        Object array = new short[][]{{1, 2}, null, {5}};
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testByteArrayArray() {
        Object array = new byte[][]{{1, 2}, null, {5}};
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testCharArrayArray() {
        Object array = new char[][]{{'A', 'B'}, null, {'p'}};
        Assert.assertEquals((Object)(this.baseStr + "[{{A,B},<null>,{p}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{A,B},<null>,{p}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testDoubleArrayArray() {
        Object array = new double[][]{{1.0, 2.29686}, null, {Double.NaN}};
        Assert.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testFloatArrayArray() {
        Object array = new float[][]{{1.0f, 2.29686f}, null, {Float.NaN}};
        Assert.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testBooleanArrayArray() {
        Object array = new boolean[][]{{true, false}, null, {false}};
        Assert.assertEquals((Object)(this.baseStr + "[{{true,false},<null>,{false}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[{{true,false},<null>,{false}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    @Test
    public void testObjectCycle() {
        ObjectCycle a = new ObjectCycle();
        ObjectCycle b = new ObjectCycle();
        a.obj = b;
        b.obj = a;
        String expected = this.toBaseString(a) + "[" + this.toBaseString(b) + "[" + this.toBaseString(a) + "]]";
        Assert.assertEquals((Object)expected, (Object)a.toString());
    }

    @Test
    public void testSimpleReflectionStatics() {
        SimpleReflectionStaticFieldsFixture instance1 = new SimpleReflectionStaticFieldsFixture();
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)true, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
    }

    @Test
    public void testReflectionStatics() {
        ReflectionStaticFieldsFixture instance1 = new ReflectionStaticFieldsFixture();
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,instanceString=instanceString,instanceInt=67890]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, ReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,staticTransientString=staticTransientString,staticTransientInt=54321,instanceString=instanceString,instanceInt=67890,transientString=transientString,transientInt=98765]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)true, (boolean)true, ReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,instanceString=instanceString,instanceInt=67890]"), (Object)this.toStringWithStatics(instance1, null, ReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,instanceString=instanceString,instanceInt=67890]"), (Object)this.toStringWithStatics(instance1, null, ReflectionStaticFieldsFixture.class));
    }

    @Test
    public void testInheritedReflectionStatics() {
        InheritedReflectionStaticFieldsFixture instance1 = new InheritedReflectionStaticFieldsFixture();
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, InheritedReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890,staticString=staticString,staticInt=12345]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890,staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
        Assert.assertEquals((Object)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890,staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
    }

    public <T> String toStringWithStatics(T object, ToStringStyle style, Class<? super T> reflectUpToClass) {
        return ReflectionToStringBuilder.toString(object, (ToStringStyle)style, (boolean)false, (boolean)true, reflectUpToClass);
    }

    @Test
    public void test_setUpToClass_valid() {
        Integer val = 5;
        ReflectionToStringBuilder test = new ReflectionToStringBuilder((Object)val);
        test.setUpToClass(Number.class);
        test.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void test_setUpToClass_invalid() {
        Integer val = 5;
        ReflectionToStringBuilder test = new ReflectionToStringBuilder((Object)val);
        try {
            test.setUpToClass(String.class);
        }
        finally {
            test.toString();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReflectionNull() {
        Assert.assertEquals((Object)"<null>", (Object)ReflectionToStringBuilder.toString(null));
    }

    @Test
    public void testAppendToStringUsingMultiLineStyle() {
        MultiLineTestObject obj = new MultiLineTestObject();
        ToStringBuilder testBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendToString(obj.toString());
        Assert.assertEquals((long)testBuilder.toString().indexOf("testInt=31337"), (long)-1L);
    }

    class MultiLineTestObject {
        Integer i = 31337;

        MultiLineTestObject() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("testInt", (Object)this.i).toString();
        }
    }

    class InheritedReflectionStaticFieldsFixture
    extends SimpleReflectionStaticFieldsFixture {
        static final String staticString2 = "staticString2";
        static final int staticInt2 = 67890;

        InheritedReflectionStaticFieldsFixture() {
        }
    }

    class SimpleReflectionStaticFieldsFixture {
        static final String staticString = "staticString";
        static final int staticInt = 12345;

        SimpleReflectionStaticFieldsFixture() {
        }
    }

    class ReflectionStaticFieldsFixture {
        static final String staticString = "staticString";
        static final int staticInt = 12345;
        static final transient String staticTransientString = "staticTransientString";
        static final transient int staticTransientInt = 54321;
        String instanceString = "instanceString";
        int instanceInt = 67890;
        transient String transientString = "transientString";
        transient int transientInt = 98765;

        ReflectionStaticFieldsFixture() {
        }
    }

    static class ObjectCycle {
        Object obj;

        ObjectCycle() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append(this.obj).toString();
        }
    }

    private static class SelfInstanceTwoVarsReflectionTestFixture {
        private final SelfInstanceTwoVarsReflectionTestFixture typeIsSelf = this;
        private final String otherType = "The Other Type";

        SelfInstanceTwoVarsReflectionTestFixture() {
        }

        public String getOtherType() {
            return this.otherType;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static class SelfInstanceVarReflectionTestFixture {
        private final SelfInstanceVarReflectionTestFixture typeIsSelf = this;

        SelfInstanceVarReflectionTestFixture() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class SimpleReflectionTestFixture {
        Object o;

        SimpleReflectionTestFixture() {
        }

        SimpleReflectionTestFixture(Object o) {
            this.o = o;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class ReflectionTestCycleB {
        ReflectionTestCycleA a;

        ReflectionTestCycleB() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class ReflectionTestCycleA {
        ReflectionTestCycleB b;

        ReflectionTestCycleA() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class Outer {
        Inner inner = new Inner();

        Outer() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        class Inner {
            Inner() {
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this);
            }
        }
    }

    static class ReflectionTestFixtureB
    extends ReflectionTestFixtureA {
        private final char b = (char)98;
        private transient char transientB = (char)116;

        ReflectionTestFixtureB() {
        }
    }

    static class ReflectionTestFixtureA {
        private final char a = (char)97;
        private transient char transientA = (char)116;

        ReflectionTestFixtureA() {
        }
    }
}

