/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiLineToStringStyleTest {
    private final Integer base = 5;
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    @Before
    public void setUp() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @After
    public void tearDown() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testBlank() {
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testAppendSuper() {
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=hello" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "  a=hello" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=hello" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  3" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=<null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=3" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=3" + System.lineSeparator() + "  b=4" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=<Integer>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=<size=0>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=[]" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=<size=0>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a={}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=<size=0>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a={}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    @Test
    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        String pBaseStr = p.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(p));
        Assert.assertEquals((Object)(pBaseStr + "[" + System.lineSeparator() + "  name=Jane Doe" + System.lineSeparator() + "  age=25" + System.lineSeparator() + "  smoker=true" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    @Test
    public void testLong() {
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  3" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=3" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  a=3" + System.lineSeparator() + "  b=4" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  {<null>,5,{3,6}}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  {<null>,5,{3,6}}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  {1,2,-3,4}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  {1,2,-3,4}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  {{1,2},<null>,{5}}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  {{1,2},<null>,{5}}" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + System.lineSeparator() + "  <null>" + System.lineSeparator() + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }
}

