/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.test.SystemDefaults;
import org.apache.commons.lang3.test.SystemDefaultsSwitch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class StringUtilsContainsTest {
    @Rule
    public SystemDefaultsSwitch defaults = new SystemDefaultsSwitch();
    private static final String CharU20000 = "\ud840\udc00";
    private static final String CharU20001 = "\ud840\udc01";
    private static final String CharUSuppCharHigh = "\udc00";
    private static final String CharUSuppCharLow = "\ud840";

    @Test
    public void testContains_Char() {
        Assert.assertFalse((boolean)StringUtils.contains(null, (int)32));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", (int)32));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", null));
        Assert.assertFalse((boolean)StringUtils.contains(null, null));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)97));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)98));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)99));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"abc", (int)122));
    }

    @Test
    public void testContains_String() {
        Assert.assertFalse((boolean)StringUtils.contains(null, null));
        Assert.assertFalse((boolean)StringUtils.contains(null, (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.contains(null, (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", null));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"b"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"c"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"z"));
    }

    @Test
    public void testContains_StringWithBadSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc01\ud840a", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc01\udc00a", (CharSequence)"a"));
    }

    @Test
    public void testContains_StringWithSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    @Test
    public void testContainsAny_StringCharArray() {
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[0]));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[]{'a', 'b'}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[0]));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'y'}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    @Test
    public void testContainsAny_StringCharArrayWithBadSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"abc\udc00xyz", (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    @Test
    public void testContainsAny_StringCharArrayWithSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"a\ud840\udc00\ud840\udc01", (char[])"a".toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00a\ud840\udc01", (char[])"a".toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01a", (char[])"a".toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    @Test
    public void testContainsAny_StringString() {
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)null));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)"ab"));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)"ab"));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"zy"));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (CharSequence)"z"));
    }

    @Test
    public void testContainsAny_StringWithBadSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
    }

    @Test
    public void testContainsAny_StringWithSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharU20000));
    }

    @Test
    public void testContainsAny_StringStringArray() {
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence[])new String[0]));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence[])new String[]{"hello"}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence[])new String[0]));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence[])new String[]{"hello"}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[0]));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"hello", "goodbye"}));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"hello", "Goodbye"}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"Hello", "Goodbye"}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"Hello", null}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, null", (CharSequence[])new String[]{"Hello", null}));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"abcd", (CharSequence[])new CharSequence[]{"ab", null}));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"abcd", (CharSequence[])new CharSequence[]{"ab", "cd"}));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"abc", (CharSequence[])new CharSequence[]{"d", "abc"}));
    }

    @SystemDefaults(locale="de_DE")
    @Test
    public void testContainsIgnoreCase_LocaleIndependence() {
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr"), Locale.getDefault()};
        String[][] tdata = new String[][]{{"i", "I"}, {"I", "i"}, {"\u03c2", "\u03c3"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}};
        String[][] fdata = new String[][]{{"\u00df", "SS"}};
        for (Locale testLocale : locales) {
            int j;
            Locale.setDefault(testLocale);
            for (j = 0; j < tdata.length; ++j) {
                Assert.assertTrue((String)(Locale.getDefault() + ": " + j + " " + tdata[j][0] + " " + tdata[j][1]), (boolean)StringUtils.containsIgnoreCase((CharSequence)tdata[j][0], (CharSequence)tdata[j][1]));
            }
            for (j = 0; j < fdata.length; ++j) {
                Assert.assertFalse((String)(Locale.getDefault() + ": " + j + " " + fdata[j][0] + " " + fdata[j][1]), (boolean)StringUtils.containsIgnoreCase((CharSequence)fdata[j][0], (CharSequence)fdata[j][1]));
            }
        }
    }

    @Test
    public void testContainsIgnoreCase_StringString() {
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, null));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", null));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", null));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", null));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"A"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"abc"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"ABC"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"ABC"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"ABC"));
    }

    @Test
    public void testContainsNone_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'.'};
        char[] chars3 = new char[]{'c', 'd'};
        char[] emptyChars = new char[]{};
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (char[])null));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])null));
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars3));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars3));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars3));
    }

    @Test
    public void testContainsNone_CharArrayWithBadSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharU20001.indexOf(CharUSuppCharHigh));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    @Test
    public void testContainsNone_CharArrayWithSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    @Test
    public void testContainsNone_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        String chars1 = "b";
        String chars2 = ".";
        String chars3 = "cd";
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (String)null));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)null));
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (String)""));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"."));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"cd"));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"b", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (String)"."));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (String)"cd"));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"."));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"cd"));
    }

    @Test
    public void testContainsNone_StringWithBadSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (String)CharU20001));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (String)CharU20001));
        Assert.assertEquals((long)-1L, (long)CharU20001.indexOf(CharUSuppCharHigh));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharHigh));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharLow));
    }

    @Test
    public void testContainsNone_StringWithSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20000));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharU20000));
    }

    @Test
    public void testContainsOnly_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'a'};
        char[] chars3 = new char[]{'a', 'b'};
        char[] emptyChars = new char[]{};
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"", (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (char[])emptyChars));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars3));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars3));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars3));
    }

    @Test
    public void testContainsOnly_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        String chars1 = "b";
        String chars2 = "a";
        String chars3 = "ab";
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (String)null));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"", (String)null));
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (String)""));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"a"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"ab"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"a"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"ab"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"a"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"ab"));
    }

    @Test
    public void testContainsWhitespace() {
        Assert.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a "));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" a"));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a\t"));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"\n"));
    }
}

