/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileWriterWithEncodingTest {
    @TempDir
    public File temporaryFolder;
    private String defaultEncoding;
    private File file1;
    private File file2;
    private String textContent;
    private final char[] anotherTestContent = new char[]{'f', 'z', 'x'};

    @BeforeEach
    public void setUp() throws Exception {
        File encodingFinder = new File(this.temporaryFolder, "finder.txt");
        try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(encodingFinder));){
            this.defaultEncoding = out.getEncoding();
        }
        this.file1 = new File(this.temporaryFolder, "testfile1.txt");
        this.file2 = new File(this.temporaryFolder, "testfile2.txt");
        char[] arr = new char[1024];
        char[] chars = "ABCDEFGHIJKLMNOPQabcdefgihklmnopq".toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = chars[i % chars.length];
        }
        this.textContent = new String(arr);
    }

    @Test
    public void sameEncoding_string_constructor() throws Exception {
        this.succesfulRun(new FileWriterWithEncoding(this.file2, this.defaultEncoding));
    }

    @Test
    public void sameEncoding_string_string_constructor() throws Exception {
        this.succesfulRun(new FileWriterWithEncoding(this.file2.getPath(), this.defaultEncoding));
    }

    @Test
    public void sameEncoding_Charset_constructor() throws Exception {
        this.succesfulRun(new FileWriterWithEncoding(this.file2, Charset.defaultCharset()));
    }

    @Test
    public void sameEncoding_string_Charset_constructor() throws Exception {
        this.succesfulRun(new FileWriterWithEncoding(this.file2.getPath(), Charset.defaultCharset()));
    }

    @Test
    public void sameEncoding_CharsetEncoder_constructor() throws Exception {
        CharsetEncoder enc = Charset.defaultCharset().newEncoder();
        this.succesfulRun(new FileWriterWithEncoding(this.file2, enc));
    }

    @Test
    public void sameEncoding_string_CharsetEncoder_constructor() throws Exception {
        CharsetEncoder enc = Charset.defaultCharset().newEncoder();
        this.succesfulRun(new FileWriterWithEncoding(this.file2.getPath(), enc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void succesfulRun(FileWriterWithEncoding fw21) throws Exception {
        FileWriter fw1 = null;
        FileWriterWithEncoding fw2 = null;
        try {
            fw1 = new FileWriter(this.file1);
            fw2 = fw21;
            this.writeTestPayload(fw1, fw2);
            TestUtils.checkFile(this.file1, this.file2);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fw1);
            IOUtils.closeQuietly(fw2);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fw1);
        IOUtils.closeQuietly((Writer)fw2);
        Assertions.assertTrue((boolean)this.file1.exists());
        Assertions.assertTrue((boolean)this.file2.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDifferentEncoding() throws Exception {
        block11: {
            FileWriterWithEncoding fw2;
            FileWriter fw1;
            block10: {
                if (!Charset.isSupported("UTF-16BE")) break block10;
                fw1 = null;
                fw2 = null;
                try {
                    fw1 = new FileWriter(this.file1);
                    fw2 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                    this.writeTestPayload(fw1, fw2);
                    try {
                        TestUtils.checkFile(this.file1, this.file2);
                        Assertions.fail();
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fw1);
                    IOUtils.closeQuietly(fw2);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)fw1);
                IOUtils.closeQuietly((Writer)fw2);
                Assertions.assertTrue((boolean)this.file1.exists());
                Assertions.assertTrue((boolean)this.file2.exists());
            }
            if (!Charset.isSupported("UTF-16LE")) break block11;
            fw1 = null;
            fw2 = null;
            try {
                fw1 = new FileWriter(this.file1);
                fw2 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                this.writeTestPayload(fw1, fw2);
                try {
                    TestUtils.checkFile(this.file1, this.file2);
                    Assertions.fail();
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)fw1);
                IOUtils.closeQuietly(fw2);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fw1);
            IOUtils.closeQuietly((Writer)fw2);
            Assertions.assertTrue((boolean)this.file1.exists());
            Assertions.assertTrue((boolean)this.file2.exists());
        }
    }

    private void writeTestPayload(FileWriter fw1, FileWriterWithEncoding fw2) throws IOException {
        Assertions.assertTrue((boolean)this.file1.exists());
        Assertions.assertTrue((boolean)this.file2.exists());
        fw1.write(this.textContent);
        fw2.write(this.textContent);
        fw1.write(65);
        fw2.write(65);
        fw1.write(this.anotherTestContent);
        fw2.write(this.anotherTestContent);
        fw1.write(this.anotherTestContent, 1, 2);
        fw2.write(this.anotherTestContent, 1, 2);
        fw1.write("CAFE", 1, 2);
        fw2.write("CAFE", 1, 2);
        fw1.flush();
        fw2.flush();
    }

    @Test
    public void constructor_File_encoding_badEncoding() {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding(this.file1, "BAD-ENCODE");
            Assertions.fail();
        }
        catch (IOException ex) {
            try {
                Assertions.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void constructor_File_directory() {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding(this.temporaryFolder, this.defaultEncoding);
            Assertions.fail();
        }
        catch (IOException ex) {
            try {
                Assertions.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void constructor_File_nullFile() throws IOException {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding((File)null, this.defaultEncoding);
            Assertions.fail();
        }
        catch (NullPointerException ex) {
            try {
                Assertions.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void constructor_fileName_nullFile() throws IOException {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding((String)null, this.defaultEncoding);
            Assertions.fail();
        }
        catch (NullPointerException ex) {
            try {
                Assertions.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void sameEncoding_null_Charset_constructor() throws Exception {
        try {
            this.succesfulRun(new FileWriterWithEncoding(this.file2, (Charset)null));
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

