/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.io.input.ReversedLinesFileReaderTestParamBlockSize;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReversedLinesFileReaderTestSimple {
    private ReversedLinesFileReader reversedLinesFileReader;

    @AfterEach
    public void closeReader() {
        try {
            this.reversedLinesFileReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testFileSizeIsExactMultipleOfBlockSize() throws URISyntaxException, IOException {
        int blockSize = 10;
        File testFile20Bytes = new File(this.getClass().getResource("/test-file-20byteslength.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, 10, "ISO-8859-1");
        String testLine = "123456789";
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("123456789", this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("123456789", this.reversedLinesFileReader.readLine());
    }

    @Test
    public void testUnsupportedEncodingUTF16() throws URISyntaxException {
        File testFileEmpty = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEmpty, 8192, "UTF-16").close());
    }

    @Test
    public void testUnsupportedEncodingBig5() throws URISyntaxException {
        File testFileEncodingBig5 = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEncodingBig5, 8192, "Big5").close());
    }
}

