/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.stream.IntStream;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ReversedLinesFileReaderTestParamBlockSize {
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final int[] BLOCK_SIZES = new int[]{1, 3, 8, 256, 4096};
    private ReversedLinesFileReader reversedLinesFileReader;
    private static final String TEST_LINE = "A Test Line. Special chars: \u00c4\u00e4\u00dc\u00fc\u00d6\u00f6\u00df \u00c3\u00e1\u00e9\u00ed\u00ef\u00e7\u00f1\u00c2 \u00a9\u00b5\u00a5\u00a3\u00b1\u00b2\u00ae";
    private static final String TEST_LINE_SHIFT_JIS1 = "Hiragana letters: \u3041\u3042\u3043\u3044\u3045";
    private static final String TEST_LINE_SHIFT_JIS2 = "Kanji letters: \u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_WINDOWS_31J_1 = "\u3041\u3042\u3043\u3044\u3045";
    private static final String TEST_LINE_WINDOWS_31J_2 = "\u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_GBK_1 = "\u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_GBK_2 = "\u7b80\u4f53\u4e2d\u6587";
    private static final String TEST_LINE_X_WINDOWS_949_1 = "\ud55c\uad6d\uc5b4";
    private static final String TEST_LINE_X_WINDOWS_949_2 = "\ub300\ud55c\ubbfc\uad6d";
    private static final String TEST_LINE_X_WINDOWS_950_1 = "\u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_X_WINDOWS_950_2 = "\u7e41\u9ad4\u4e2d\u6587";

    public static IntStream blockSizes() {
        return IntStream.of(1, 3, 8, 256, 4096);
    }

    @AfterEach
    public void closeReader() {
        try {
            this.reversedLinesFileReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testIsoFileDefaults(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-iso8859-1.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, ISO_8859_1);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUTF8FileWindowsBreaks(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-utf8-win-linebr.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUTF8FileCRBreaks(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-utf8-cr-only.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUTF8File(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-utf8.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testEmptyFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileEmpty = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileEmpty, testParamBlockSize, UTF_8);
        Assertions.assertNull((Object)this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUTF16BEFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileUTF16BE = new File(this.getClass().getResource("/test-file-utf16be.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUTF16BE, testParamBlockSize, "UTF-16BE");
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUTF16LEFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileUTF16LE = new File(this.getClass().getResource("/test-file-utf16le.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUTF16LE, testParamBlockSize, "UTF-16LE");
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testShiftJISFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileShiftJIS = new File(this.getClass().getResource("/test-file-shiftjis.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileShiftJIS, testParamBlockSize, "Shift_JIS");
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_SHIFT_JIS2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_SHIFT_JIS1, this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testWindows31jFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileWindows31J = new File(this.getClass().getResource("/test-file-windows-31j.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileWindows31J, testParamBlockSize, "windows-31j");
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("\u660e\u8f38\u5b50\u4eac", this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_WINDOWS_31J_1, this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testGBK(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileGBK = new File(this.getClass().getResource("/test-file-gbk.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileGBK, testParamBlockSize, "GBK");
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_GBK_2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("\u660e\u8f38\u5b50\u4eac", this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testxWindows949File(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFilexWindows949 = new File(this.getClass().getResource("/test-file-x-windows-949.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFilexWindows949, testParamBlockSize, "x-windows-949");
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_X_WINDOWS_949_2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_X_WINDOWS_949_1, this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testxWindows950File(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFilexWindows950 = new File(this.getClass().getResource("/test-file-x-windows-950.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFilexWindows950, testParamBlockSize, "x-windows-950");
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_X_WINDOWS_950_2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("\u660e\u8f38\u5b50\u4eac", this.reversedLinesFileReader.readLine());
    }

    @Test
    public void testFileSizeIsExactMultipleOfBlockSize() throws URISyntaxException, IOException {
        int blockSize = 10;
        File testFile20Bytes = new File(this.getClass().getResource("/test-file-20byteslength.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, 10, ISO_8859_1);
        String testLine = "123456789";
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("123456789", this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("123456789", this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUTF8FileWindowsBreaksSmallBlockSize2VerifyBlockSpanningNewLines(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileUtf8 = new File(this.getClass().getResource("/test-file-utf8-win-linebr.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUtf8, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testIsoFileManyWindowsBreaksSmallBlockSize2VerifyBlockSpanningNewLines(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-iso8859-1-shortlines-win-linebr.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, ISO_8859_1);
        for (int i = 3; i > 0; --i) {
            for (int j = 1; j <= 3; ++j) {
                ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("", this.reversedLinesFileReader.readLine());
            }
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("" + i, this.reversedLinesFileReader.readLine());
        }
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUnsupportedEncodingUTF16(int testParamBlockSize) throws URISyntaxException {
        File testFileEmpty = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEmpty, testParamBlockSize, "UTF-16").close());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    public void testUnsupportedEncodingBig5(int testParamBlockSize) throws URISyntaxException {
        File testFileEncodingBig5 = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEncodingBig5, testParamBlockSize, "Big5").close());
    }

    private void assertFileWithShrinkingTestLines(ReversedLinesFileReader reversedLinesFileReader) throws IOException {
        String line = null;
        int lineCount = 0;
        while ((line = reversedLinesFileReader.readLine()) != null) {
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("Line " + ++lineCount + " is not matching", TEST_LINE.substring(0, lineCount), line);
        }
    }

    static void assertEqualsAndNoLineBreaks(String msg, String expected, String actual) {
        if (actual != null) {
            Assertions.assertFalse((boolean)actual.contains("\n"), (String)("Line contains \\n: line=" + actual));
            Assertions.assertFalse((boolean)actual.contains("\r"), (String)("Line contains \\r: line=" + actual));
        }
        Assertions.assertEquals((Object)expected, (Object)actual, (String)msg);
    }

    static void assertEqualsAndNoLineBreaks(String expected, String actual) {
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(null, expected, actual);
    }
}

