/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TestArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathUtilsTest
extends TestArguments {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFile() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        try {
            Path sourceFile = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]);
            Path targetFile = PathUtils.copyFileToDirectory((Path)sourceFile, (Path)tempDir, (CopyOption[])new CopyOption[0]);
            Assertions.assertTrue((boolean)Files.exists(targetFile, new LinkOption[0]));
            Assertions.assertEquals((long)Files.size(sourceFile), (long)Files.size(targetFile));
        }
        finally {
            PathUtils.deleteDirectory((Path)tempDir);
        }
    }
}

