/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.output.LockableFileWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LockableFileWriterTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File file;
    private File lockDir;
    private File lockFile;
    private File altLockDir;
    private File altLockFile;

    private File getTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    @Before
    public void setUp() {
        this.file = new File(this.getTestDirectory(), "testlockfile");
        this.lockDir = new File(System.getProperty("java.io.tmpdir"));
        this.lockFile = new File(this.lockDir, this.file.getName() + ".lck");
        this.altLockDir = this.getTestDirectory();
        this.altLockFile = new File(this.altLockDir, this.file.getName() + ".lck");
    }

    @Test
    public void testFileLocked() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file);){
            Object msg;
            Assert.assertTrue((boolean)this.file.exists());
            Assert.assertTrue((boolean)this.lockFile.exists());
            try (LockableFileWriter lfw2 = new LockableFileWriter(this.file);){
                Assert.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                Assert.assertTrue((String)"Exception message does not start correctly. ", (boolean)((String)msg).startsWith("Can't write file, lock "));
                Assert.assertTrue((boolean)this.file.exists());
                Assert.assertTrue((boolean)this.lockFile.exists());
            }
            try {
                LockableFileWriter lfw3 = new LockableFileWriter(this.file);
                msg = null;
                try {
                    Assert.fail((String)"Somehow able to open a locked file. ");
                }
                catch (Throwable throwable) {
                    msg = throwable;
                    throw throwable;
                }
                finally {
                    if (lfw3 != null) {
                        if (msg != null) {
                            try {
                                lfw3.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)msg).addSuppressed(throwable);
                            }
                        } else {
                            lfw3.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                Assert.assertTrue((String)"Exception message does not start correctly. ", (boolean)((String)msg).startsWith("Can't write file, lock "));
                Assert.assertTrue((boolean)this.file.exists());
                Assert.assertTrue((boolean)this.lockFile.exists());
            }
        }
        Assert.assertTrue((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testAlternateLockDir() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file, "UTF-8", true, this.altLockDir.getAbsolutePath());){
            Assert.assertTrue((boolean)this.file.exists());
            Assert.assertTrue((boolean)this.altLockFile.exists());
            try (LockableFileWriter lfw2 = new LockableFileWriter(this.file, StandardCharsets.UTF_8, true, this.altLockDir.getAbsolutePath());){
                Assert.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                Assert.assertTrue((String)"Exception message does not start correctly. ", (boolean)msg.startsWith("Can't write file, lock "));
                Assert.assertTrue((boolean)this.file.exists());
                Assert.assertTrue((boolean)this.altLockFile.exists());
            }
        }
        Assert.assertTrue((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.altLockFile.exists());
    }

    @Test
    public void testFileNotLocked() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file);){
            Assert.assertTrue((boolean)this.file.exists());
            Assert.assertTrue((boolean)this.lockFile.exists());
        }
        Assert.assertTrue((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.lockFile.exists());
        var2_2 = null;
        try (LockableFileWriter lfw2 = new LockableFileWriter(this.file);){
            Assert.assertTrue((boolean)this.file.exists());
            Assert.assertTrue((boolean)this.lockFile.exists());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        Assert.assertTrue((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_encoding_badEncoding() throws IOException {
        try (LockableFileWriter writer = new LockableFileWriter(this.file, "BAD-ENCODE");){
            Assert.fail();
        }
        catch (UnsupportedCharsetException ex) {
            Assert.assertFalse((boolean)this.file.exists());
            Assert.assertFalse((boolean)this.lockFile.exists());
        }
        Assert.assertFalse((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_directory() {
        try (LockableFileWriter writer = new LockableFileWriter(this.getTestDirectory());){
            Assert.fail();
        }
        catch (IOException ex) {
            Assert.assertFalse((boolean)this.file.exists());
            Assert.assertFalse((boolean)this.lockFile.exists());
        }
        Assert.assertFalse((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_nullFile() throws IOException {
        try (LockableFileWriter writer = new LockableFileWriter((File)null);){
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertFalse((boolean)this.file.exists());
            Assert.assertFalse((boolean)this.lockFile.exists());
        }
        Assert.assertFalse((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_fileName_nullFile() throws IOException {
        try (LockableFileWriter writer = new LockableFileWriter((String)null);){
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertFalse((boolean)this.file.exists());
            Assert.assertFalse((boolean)this.lockFile.exists());
        }
        Assert.assertFalse((boolean)this.file.exists());
        Assert.assertFalse((boolean)this.lockFile.exists());
    }
}

