/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ChunkedOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class ChunkedOutputStreamTest {
    @Test
    public void write_four_chunks() throws Exception {
        AtomicInteger numWrites = new AtomicInteger();
        ByteArrayOutputStream baos = this.getByteArrayOutputStream(numWrites);
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)baos, 10);
        chunked.write("0123456789012345678901234567891".getBytes());
        Assert.assertEquals((long)4L, (long)numWrites.get());
        chunked.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void negative_chunksize_not_permitted() throws Exception {
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)new ByteArrayOutputStream(), 0);
        chunked.close();
    }

    @Test
    public void defaultConstructor() throws IOException {
        AtomicInteger numWrites = new AtomicInteger();
        ByteArrayOutputStream baos = this.getByteArrayOutputStream(numWrites);
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)baos);
        chunked.write(new byte[4097]);
        Assert.assertEquals((long)2L, (long)numWrites.get());
        chunked.close();
    }

    private ByteArrayOutputStream getByteArrayOutputStream(final AtomicInteger numWrites) {
        return new ByteArrayOutputStream(){

            public void write(byte[] b, int off, int len) {
                numWrites.incrementAndGet();
                super.write(b, off, len);
            }
        };
    }
}

