/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.TaggedInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TaggedInputStreamTest {
    @Test
    public void testEmptyStream() throws IOException {
        TaggedInputStream stream = new TaggedInputStream((InputStream)new ClosedInputStream());
        Assert.assertEquals((long)0L, (long)stream.available());
        Assert.assertEquals((long)-1L, (long)stream.read());
        Assert.assertEquals((long)-1L, (long)stream.read(new byte[1]));
        Assert.assertEquals((long)-1L, (long)stream.read(new byte[1], 0, 1));
        stream.close();
    }

    @Test
    public void testNormalStream() throws IOException {
        TaggedInputStream stream = new TaggedInputStream((InputStream)new ByteArrayInputStream(new byte[]{97, 98, 99}));
        Assert.assertEquals((long)3L, (long)stream.available());
        Assert.assertEquals((long)97L, (long)stream.read());
        byte[] buffer = new byte[1];
        Assert.assertEquals((long)1L, (long)stream.read(buffer));
        Assert.assertEquals((long)98L, (long)buffer[0]);
        Assert.assertEquals((long)1L, (long)stream.read(buffer, 0, 1));
        Assert.assertEquals((long)99L, (long)buffer[0]);
        Assert.assertEquals((long)-1L, (long)stream.read());
        stream.close();
    }

    @Test
    public void testBrokenStream() {
        IOException exception = new IOException("test exception");
        TaggedInputStream stream = new TaggedInputStream((InputStream)new BrokenInputStream(exception));
        try {
            stream.available();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                Assert.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assert.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.read();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                Assert.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assert.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.close();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                Assert.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assert.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        ClosedInputStream closed = new ClosedInputStream();
        TaggedInputStream stream = new TaggedInputStream((InputStream)closed);
        Assert.assertFalse((boolean)stream.isCauseOf((Throwable)exception));
        Assert.assertFalse((boolean)stream.isCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
        stream.throwIfCauseOf((Throwable)exception);
        stream.throwIfCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        stream.close();
    }
}

