/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.MessageDigestCalculatingInputStreamTest;
import org.apache.commons.io.input.ObservableInputStream;
import org.junit.Assert;
import org.junit.Test;

public class ObservableInputStreamTest {
    @Test
    public void testDataByteCalled() throws Exception {
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(4096);
        ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer));
        LastByteKeepingObserver lko = new LastByteKeepingObserver();
        Assert.assertEquals((long)-1L, (long)lko.lastByteSeen);
        ois.read();
        Assert.assertEquals((long)-1L, (long)lko.lastByteSeen);
        Assert.assertFalse((boolean)lko.finished);
        Assert.assertFalse((boolean)lko.closed);
        ois.add((ObservableInputStream.Observer)lko);
        for (int i = 1; i < buffer.length; ++i) {
            int result = ois.read();
            Assert.assertEquals((long)((byte)result), (long)buffer[i]);
            Assert.assertEquals((long)result, (long)lko.lastByteSeen);
            Assert.assertFalse((boolean)lko.finished);
            Assert.assertFalse((boolean)lko.closed);
        }
        int result = ois.read();
        Assert.assertEquals((long)-1L, (long)result);
        Assert.assertTrue((boolean)lko.finished);
        Assert.assertFalse((boolean)lko.closed);
        ois.close();
        Assert.assertTrue((boolean)lko.finished);
        Assert.assertTrue((boolean)lko.closed);
    }

    @Test
    public void testDataBytesCalled() throws Exception {
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(4096);
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ObservableInputStream ois = new ObservableInputStream((InputStream)bais);
        LastBytesKeepingObserver lko = new LastBytesKeepingObserver();
        byte[] readBuffer = new byte[23];
        Assert.assertEquals(null, (Object)lko.buffer);
        ois.read(readBuffer);
        Assert.assertEquals(null, (Object)lko.buffer);
        ois.add((ObservableInputStream.Observer)lko);
        while (true) {
            if (bais.available() >= 2048) {
                int result = ois.read(readBuffer);
                if (result == -1) {
                    ois.close();
                    break;
                }
                Assert.assertEquals((Object)readBuffer, (Object)lko.buffer);
                Assert.assertEquals((long)0L, (long)lko.offset);
                Assert.assertEquals((long)readBuffer.length, (long)lko.length);
                continue;
            }
            int res = Math.min(11, bais.available());
            int result = ois.read(readBuffer, 1, 11);
            if (result == -1) {
                ois.close();
                break;
            }
            Assert.assertEquals((Object)readBuffer, (Object)lko.buffer);
            Assert.assertEquals((long)1L, (long)lko.offset);
            Assert.assertEquals((long)res, (long)lko.length);
        }
    }

    private static class LastBytesKeepingObserver
    extends ObservableInputStream.Observer {
        private byte[] buffer = null;
        private int offset = -1;
        private int length = -1;

        private LastBytesKeepingObserver() {
        }

        void data(byte[] pBuffer, int pOffset, int pLength) throws IOException {
            super.data(pBuffer, pOffset, pLength);
            this.buffer = pBuffer;
            this.offset = pOffset;
            this.length = pLength;
        }
    }

    private static class LastByteKeepingObserver
    extends ObservableInputStream.Observer {
        private int lastByteSeen = -1;
        private boolean finished;
        private boolean closed;

        private LastByteKeepingObserver() {
        }

        void data(int pByte) throws IOException {
            super.data(pByte);
            this.lastByteSeen = pByte;
        }

        void finished() throws IOException {
            super.finished();
            this.finished = true;
        }

        void closed() throws IOException {
            super.closed();
            this.closed = true;
        }
    }
}

