/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.junit.Assert;
import org.junit.Test;

public class NullInputStreamTest {
    @Test
    public void testRead() throws Exception {
        int size = 5;
        TestNullInputStream input = new TestNullInputStream(5);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("Check Size [" + i + "]"), (long)(5 - i), (long)((InputStream)((Object)input)).available());
            Assert.assertEquals((String)("Check Value [" + i + "]"), (long)i, (long)((InputStream)((Object)input)).read());
        }
        Assert.assertEquals((String)"Available after contents all read", (long)0L, (long)((InputStream)((Object)input)).available());
        Assert.assertEquals((String)"End of File", (long)-1L, (long)((InputStream)((Object)input)).read());
        Assert.assertEquals((String)"Available after End of File", (long)0L, (long)((InputStream)((Object)input)).available());
        try {
            int result = ((InputStream)((Object)input)).read();
            Assert.fail((String)("Should have thrown an IOException, byte=[" + result + "]"));
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
        Assert.assertEquals((String)"Available after close", (long)5L, (long)((InputStream)((Object)input)).available());
    }

    @Test
    public void testReadByteArray() throws Exception {
        byte[] bytes = new byte[10];
        TestNullInputStream input = new TestNullInputStream(15);
        int count1 = ((InputStream)((Object)input)).read(bytes);
        Assert.assertEquals((String)"Read 1", (long)bytes.length, (long)count1);
        for (int i = 0; i < count1; ++i) {
            Assert.assertEquals((String)"Check Bytes 1", (long)i, (long)bytes[i]);
        }
        int count2 = ((InputStream)((Object)input)).read(bytes);
        Assert.assertEquals((String)"Read 2", (long)5L, (long)count2);
        for (int i = 0; i < count2; ++i) {
            Assert.assertEquals((String)"Check Bytes 2", (long)(count1 + i), (long)bytes[i]);
        }
        int count3 = ((InputStream)((Object)input)).read(bytes);
        Assert.assertEquals((String)"Read 3 (EOF)", (long)-1L, (long)count3);
        try {
            int count4 = ((InputStream)((Object)input)).read(bytes);
            Assert.fail((String)("Should have thrown an IOException, byte=[" + count4 + "]"));
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
        int offset = 2;
        int lth = 4;
        int count5 = ((InputStream)((Object)input)).read(bytes, 2, 4);
        Assert.assertEquals((String)"Read 5", (long)4L, (long)count5);
        for (int i = 2; i < 4; ++i) {
            Assert.assertEquals((String)"Check Bytes 2", (long)i, (long)bytes[i]);
        }
    }

    @Test
    public void testEOFException() throws Exception {
        TestNullInputStream input = new TestNullInputStream(2, false, true);
        Assert.assertEquals((String)"Read 1", (long)0L, (long)((InputStream)((Object)input)).read());
        Assert.assertEquals((String)"Read 2", (long)1L, (long)((InputStream)((Object)input)).read());
        try {
            int result = ((InputStream)((Object)input)).read();
            Assert.fail((String)("Should have thrown an EOFException, byte=[" + result + "]"));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        ((InputStream)((Object)input)).close();
    }

    @Test
    public void testMarkAndReset() throws Exception {
        int i;
        int position = 0;
        int readlimit = 10;
        TestNullInputStream input = new TestNullInputStream(100, true, false);
        Assert.assertTrue((String)"Mark Should be Supported", (boolean)((InputStream)((Object)input)).markSupported());
        try {
            ((InputStream)((Object)input)).reset();
            Assert.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"No Mark IOException message", (Object)"No position has been marked", (Object)e.getMessage());
        }
        while (position < 3) {
            Assert.assertEquals((String)("Read Before Mark [" + position + "]"), (long)position, (long)((InputStream)((Object)input)).read());
            ++position;
        }
        ((InputStream)((Object)input)).mark(10);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((String)("Read After Mark [" + i + "]"), (long)(position + i), (long)((InputStream)((Object)input)).read());
        }
        ((InputStream)((Object)input)).reset();
        for (i = 0; i < 11; ++i) {
            Assert.assertEquals((String)("Read After Reset [" + i + "]"), (long)(position + i), (long)((InputStream)((Object)input)).read());
        }
        try {
            ((InputStream)((Object)input)).reset();
            Assert.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Read limit IOException message", (Object)("Marked position [" + position + "] is no longer valid - passed the read limit [" + 10 + "]"), (Object)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
    }

    @Test
    public void testMarkNotSupported() throws Exception {
        TestNullInputStream input = new TestNullInputStream(100, false, true);
        Assert.assertFalse((String)"Mark Should NOT be Supported", (boolean)((InputStream)((Object)input)).markSupported());
        try {
            ((InputStream)((Object)input)).mark(5);
            Assert.fail((String)"mark() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((String)"mark() error message", (Object)"Mark not supported", (Object)e.getMessage());
        }
        try {
            ((InputStream)((Object)input)).reset();
            Assert.fail((String)"reset() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((String)"reset() error message", (Object)"Mark not supported", (Object)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
    }

    @Test
    public void testSkip() throws Exception {
        TestNullInputStream input = new TestNullInputStream(10, true, false);
        Assert.assertEquals((String)"Read 1", (long)0L, (long)((InputStream)((Object)input)).read());
        Assert.assertEquals((String)"Read 2", (long)1L, (long)((InputStream)((Object)input)).read());
        Assert.assertEquals((String)"Skip 1", (long)5L, (long)((InputStream)((Object)input)).skip(5L));
        Assert.assertEquals((String)"Read 3", (long)7L, (long)((InputStream)((Object)input)).read());
        Assert.assertEquals((String)"Skip 2", (long)2L, (long)((InputStream)((Object)input)).skip(5L));
        Assert.assertEquals((String)"Skip 3 (EOF)", (long)-1L, (long)((InputStream)((Object)input)).skip(5L));
        try {
            ((InputStream)((Object)input)).skip(5L);
            Assert.fail((String)"Expected IOException for skipping after end of file");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Skip after EOF IOException message", (Object)"Skip after end of file", (Object)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
    }

    private static final class TestNullInputStream
    extends NullInputStream {
        public TestNullInputStream(int size) {
            super((long)size);
        }

        public TestNullInputStream(int size, boolean markSupported, boolean throwEofException) {
            super((long)size, markSupported, throwEofException);
        }

        protected int processByte() {
            return (int)this.getPosition() - 1;
        }

        protected void processBytes(byte[] bytes, int offset, int length) {
            int startPos = (int)this.getPosition() - length;
            for (int i = offset; i < length; ++i) {
                bytes[i] = (byte)(startPos + i);
            }
        }
    }
}

