/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Random;
import org.apache.commons.io.input.MessageDigestCalculatingInputStream;
import org.junit.Assert;
import org.junit.Test;

public class MessageDigestCalculatingInputStreamTest {
    public static byte[] generateRandomByteStream(int pSize) {
        byte[] buffer = new byte[pSize];
        Random rnd = new Random();
        rnd.nextBytes(buffer);
        return buffer;
    }

    @Test
    public void test() throws Exception {
        for (int i = 256; i < 8192; i *= 2) {
            byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(i);
            MessageDigest md5Sum = MessageDigest.getInstance("MD5");
            byte[] expect = md5Sum.digest(buffer);
            try (MessageDigestCalculatingInputStream md5InputStream = new MessageDigestCalculatingInputStream((InputStream)new ByteArrayInputStream(buffer));){
                md5InputStream.consume();
                byte[] got = md5InputStream.getMessageDigest().digest();
                Assert.assertArrayEquals((byte[])expect, (byte[])got);
                continue;
            }
        }
    }
}

