/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class CountingInputStreamTest {
    @Test
    public void testCounting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = "A piece of text".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[21];
        byte[] ba = new byte[5];
        int found = cis.read(ba);
        System.arraycopy(ba, 0, result, 0, 5);
        Assert.assertEquals((long)found, (long)cis.getCount());
        int value = cis.read();
        result[5] = (byte)value;
        Assert.assertEquals((long)(++found), (long)cis.getCount());
        Assert.assertEquals((long)(found += cis.read(result, 6, 5)), (long)cis.getCount());
        Assert.assertEquals((long)(found += cis.read(result, 11, 10)), (long)cis.getCount());
        String textResult = new String(result).trim();
        Assert.assertEquals((Object)textResult, (Object)"A piece of text");
        cis.close();
    }

    @Test
    public void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(0x80000000L);
        CountingInputStream cis = new CountingInputStream((InputStream)mock);
        NullOutputStream out = new NullOutputStream();
        IOUtils.copyLarge((InputStream)cis, (OutputStream)out);
        try {
            cis.getCount();
            Assert.fail((String)"Expected getCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        try {
            cis.resetCount();
            Assert.fail((String)"Expected resetCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        mock.close();
        IOUtils.copyLarge((InputStream)cis, (OutputStream)out);
        Assert.assertEquals((String)"getByteCount()", (long)0x80000000L, (long)cis.getByteCount());
        Assert.assertEquals((String)"resetByteCount()", (long)0x80000000L, (long)cis.resetByteCount());
    }

    @Test
    public void testResetting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = "A piece of text".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[bytes.length];
        int found = cis.read(result, 0, 5);
        Assert.assertEquals((long)found, (long)cis.getCount());
        int count = cis.resetCount();
        found = cis.read(result, 6, 5);
        Assert.assertEquals((long)found, (long)count);
        cis.close();
    }

    @Test
    public void testZeroLength1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        int found = cis.read();
        Assert.assertEquals((long)-1L, (long)found);
        Assert.assertEquals((long)0L, (long)cis.getCount());
        cis.close();
    }

    @Test
    public void testZeroLength2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result);
        Assert.assertEquals((long)-1L, (long)found);
        Assert.assertEquals((long)0L, (long)cis.getCount());
        cis.close();
    }

    @Test
    public void testZeroLength3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result, 0, 5);
        Assert.assertEquals((long)-1L, (long)found);
        Assert.assertEquals((long)0L, (long)cis.getCount());
        cis.close();
    }

    @Test
    public void testEOF1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        int found = cis.read();
        Assert.assertEquals((long)0L, (long)found);
        Assert.assertEquals((long)1L, (long)cis.getCount());
        found = cis.read();
        Assert.assertEquals((long)0L, (long)found);
        Assert.assertEquals((long)2L, (long)cis.getCount());
        found = cis.read();
        Assert.assertEquals((long)-1L, (long)found);
        Assert.assertEquals((long)2L, (long)cis.getCount());
        cis.close();
    }

    @Test
    public void testEOF2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result);
        Assert.assertEquals((long)2L, (long)found);
        Assert.assertEquals((long)2L, (long)cis.getCount());
        cis.close();
    }

    @Test
    public void testEOF3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result, 0, 5);
        Assert.assertEquals((long)2L, (long)found);
        Assert.assertEquals((long)2L, (long)cis.getCount());
        cis.close();
    }

    @Test
    public void testSkipping() throws IOException {
        String text = "Hello World!";
        byte[] bytes = "Hello World!".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        Assert.assertEquals((long)6L, (long)cis.skip(6L));
        Assert.assertEquals((long)6L, (long)cis.getCount());
        byte[] result = new byte[6];
        cis.read(result);
        Assert.assertEquals((Object)"World!", (Object)new String(result));
        Assert.assertEquals((long)12L, (long)cis.getCount());
        cis.close();
    }
}

