/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.BrokenInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BrokenInputStreamTest {
    private IOException exception;
    private InputStream stream;

    @Before
    public void setUp() {
        this.exception = new IOException("test exception");
        this.stream = new BrokenInputStream(this.exception);
    }

    @Test
    public void testRead() {
        try {
            this.stream.read();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.read(new byte[1]);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.read(new byte[1], 0, 1);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testAvailable() {
        try {
            this.stream.available();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testSkip() {
        try {
            this.stream.skip(1L);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testReset() {
        try {
            this.stream.reset();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testClose() {
        try {
            this.stream.close();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)this.exception, (Object)e);
        }
    }
}

