/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.BoundedReader;
import org.junit.Assert;
import org.junit.Test;

public class BoundedReaderTest {
    private final Reader sr = new BufferedReader(new StringReader("01234567890"));
    private final Reader shortReader = new BufferedReader(new StringReader("01"));

    @Test
    public void readTillEnd() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        mr.read();
        mr.read();
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void shortReader() throws IOException {
        BoundedReader mr = new BoundedReader(this.shortReader, 3);
        mr.read();
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void readMulti() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        char[] cbuf = new char[4];
        for (int i = 0; i < cbuf.length; ++i) {
            cbuf[i] = 88;
        }
        int read = mr.read(cbuf, 0, 4);
        Assert.assertEquals((long)3L, (long)read);
        Assert.assertEquals((long)48L, (long)cbuf[0]);
        Assert.assertEquals((long)49L, (long)cbuf[1]);
        Assert.assertEquals((long)50L, (long)cbuf[2]);
        Assert.assertEquals((long)88L, (long)cbuf[3]);
        mr.close();
    }

    @Test
    public void readMultiWithOffset() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        char[] cbuf = new char[4];
        for (int i = 0; i < cbuf.length; ++i) {
            cbuf[i] = 88;
        }
        int read = mr.read(cbuf, 1, 2);
        Assert.assertEquals((long)2L, (long)read);
        Assert.assertEquals((long)88L, (long)cbuf[0]);
        Assert.assertEquals((long)48L, (long)cbuf[1]);
        Assert.assertEquals((long)49L, (long)cbuf[2]);
        Assert.assertEquals((long)88L, (long)cbuf[3]);
        mr.close();
    }

    @Test
    public void markReset() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        mr.mark(3);
        mr.read();
        mr.read();
        mr.read();
        mr.reset();
        mr.read();
        mr.read();
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void markResetWithMarkOutsideBoundedReaderMax() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        mr.mark(4);
        mr.read();
        mr.read();
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void markResetWithMarkOutsideBoundedReaderMaxAndInitialOffset() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        mr.read();
        mr.mark(3);
        mr.read();
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void markResetFromOffset1() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        mr.mark(3);
        mr.read();
        mr.read();
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.reset();
        mr.mark(1);
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void markResetMarkMore() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        mr.mark(4);
        mr.read();
        mr.read();
        mr.read();
        mr.reset();
        mr.read();
        mr.read();
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void skipTest() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        mr.skip(2L);
        mr.read();
        Assert.assertEquals((long)-1L, (long)mr.read());
        mr.close();
    }

    @Test
    public void closeTest() throws IOException {
        final AtomicBoolean closed = new AtomicBoolean(false);
        BufferedReader sr = new BufferedReader(new StringReader("01234567890")){

            @Override
            public void close() throws IOException {
                closed.set(true);
                super.close();
            }
        };
        BoundedReader mr = new BoundedReader((Reader)sr, 3);
        mr.close();
        Assert.assertTrue((boolean)closed.get());
    }

    @Test(timeout=5000L)
    public void testReadBytesEOF() throws IOException {
        BoundedReader mr = new BoundedReader(this.sr, 3);
        try (BufferedReader br = new BufferedReader((Reader)mr);){
            br.readLine();
            br.readLine();
        }
    }
}

