/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AutoCloseInputStreamTest {
    private byte[] data;
    private InputStream stream;
    private boolean closed;

    @Before
    public void setUp() {
        this.data = new byte[]{120, 121, 122};
        this.stream = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(this.data){

            @Override
            public void close() {
                AutoCloseInputStreamTest.this.closed = true;
            }
        });
        this.closed = false;
    }

    @Test
    public void testClose() throws IOException {
        this.stream.close();
        Assert.assertTrue((String)"closed", (boolean)this.closed);
        Assert.assertEquals((String)"read()", (long)-1L, (long)this.stream.read());
    }

    @Test
    public void testRead() throws IOException {
        for (byte element : this.data) {
            Assert.assertEquals((String)"read()", (long)element, (long)this.stream.read());
            Assert.assertFalse((String)"closed", (boolean)this.closed);
        }
        Assert.assertEquals((String)"read()", (long)-1L, (long)this.stream.read());
        Assert.assertTrue((String)"closed", (boolean)this.closed);
    }

    @Test
    public void testReadBuffer() throws IOException {
        byte[] b = new byte[this.data.length * 2];
        int total = 0;
        int n = 0;
        while (n != -1) {
            Assert.assertFalse((String)"closed", (boolean)this.closed);
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((String)"read(b)", (long)this.data[total + i], (long)b[i]);
            }
            total += n;
            n = this.stream.read(b);
        }
        Assert.assertEquals((String)"read(b)", (long)this.data.length, (long)total);
        Assert.assertTrue((String)"closed", (boolean)this.closed);
        Assert.assertEquals((String)"read(b)", (long)-1L, (long)this.stream.read(b));
    }

    @Test
    public void testReadBufferOffsetLength() throws IOException {
        byte[] b = new byte[this.data.length * 2];
        int total = 0;
        int n = 0;
        while (n != -1) {
            Assert.assertFalse((String)"closed", (boolean)this.closed);
            n = this.stream.read(b, total += n, b.length - total);
        }
        Assert.assertEquals((String)"read(b, off, len)", (long)this.data.length, (long)total);
        for (int i = 0; i < this.data.length; ++i) {
            Assert.assertEquals((String)"read(b, off, len)", (long)this.data[i], (long)b[i]);
        }
        Assert.assertTrue((String)"closed", (boolean)this.closed);
        Assert.assertEquals((String)"read(b, off, len)", (long)-1L, (long)this.stream.read(b, 0, b.length));
    }
}

