/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.Assert;

public abstract class IOFileFilterAbstractTestCase {
    public static void assertFileFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) throws Exception {
        Assert.assertEquals((String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file), (Object)expected, (Object)filter.accept(file));
    }

    public static void assertFilenameFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) throws Exception {
        Assert.assertEquals((String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file), (Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()));
    }

    public static void assertFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) throws Exception {
        Assert.assertEquals((String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file), (Object)expected, (Object)filter.accept(file));
        if (file != null && file.getParentFile() != null) {
            Assert.assertEquals((String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file), (Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()));
        } else if (file == null) {
            Assert.assertEquals((String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"), (Object)expected, (Object)filter.accept(file));
        }
    }

    public static void assertTrueFiltersInvoked(int testNumber, TesterTrueFileFilter[] filters, boolean[] invoked) {
        for (int i = 1; i < filters.length; ++i) {
            Assert.assertEquals((String)("test " + testNumber + " filter " + i + " invoked"), (Object)invoked[i - 1], (Object)filters[i].isInvoked());
        }
    }

    public static void assertFalseFiltersInvoked(int testNumber, TesterFalseFileFilter[] filters, boolean[] invoked) {
        for (int i = 1; i < filters.length; ++i) {
            Assert.assertEquals((String)("test " + testNumber + " filter " + i + " invoked"), (Object)invoked[i - 1], (Object)filters[i].isInvoked());
        }
    }

    public static File determineWorkingDirectoryPath(String key, String defaultPath) {
        String workingPathName = System.getProperty(key, defaultPath);
        return new File(workingPathName);
    }

    public static void resetFalseFilters(TesterFalseFileFilter[] filters) {
        for (TesterFalseFileFilter filter : filters) {
            if (filter == null) continue;
            filter.reset();
        }
    }

    public static void resetTrueFilters(TesterTrueFileFilter[] filters) {
        for (TesterTrueFileFilter filter : filters) {
            if (filter == null) continue;
            filter.reset();
        }
    }

    class TesterFalseFileFilter
    extends FalseFileFilter {
        private static final long serialVersionUID = -3603047664010401872L;
        private boolean invoked;

        TesterFalseFileFilter() {
        }

        public boolean accept(File file) {
            this.setInvoked(true);
            return super.accept(file);
        }

        public boolean accept(File file, String str) {
            this.setInvoked(true);
            return super.accept(file, str);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void setInvoked(boolean invoked) {
            this.invoked = invoked;
        }

        public void reset() {
            this.setInvoked(false);
        }
    }

    class TesterTrueFileFilter
    extends TrueFileFilter {
        private static final long serialVersionUID = 1828930358172422914L;
        private boolean invoked;

        TesterTrueFileFilter() {
        }

        public boolean accept(File file) {
            this.setInvoked(true);
            return super.accept(file);
        }

        public boolean accept(File file, String str) {
            this.setInvoked(true);
            return super.accept(file, str);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void setInvoked(boolean invoked) {
            this.invoked = invoked;
        }

        public void reset() {
            this.setInvoked(false);
        }
    }
}

