/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.CompositeFileComparator;
import org.apache.commons.io.comparator.ExtensionFileComparator;
import org.apache.commons.io.comparator.ReverseComparator;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeFileComparatorTest
extends ComparatorAbstractTestCase {
    @Before
    public void setUp() throws Exception {
        this.comparator = new CompositeFileComparator((Comparator[])new AbstractFileComparator[]{(AbstractFileComparator)SizeFileComparator.SIZE_COMPARATOR, (AbstractFileComparator)ExtensionFileComparator.EXTENSION_COMPARATOR});
        this.reverse = new ReverseComparator((Comparator)this.comparator);
        File dir = this.getTestDirectory();
        this.lessFile = new File(dir, "xyz.txt");
        this.equalFile1 = new File(dir, "foo.txt");
        this.equalFile2 = new File(dir, "bar.txt");
        this.moreFile = new File(dir, "foo.xyz");
        if (!this.lessFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.lessFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(new FileOutputStream(this.lessFile));){
            TestUtils.generateTestData(output3, 32L);
        }
        if (!this.equalFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.equalFile1 + " as the parent directory does not exist");
        }
        var3_3 = null;
        try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(this.equalFile1));){
            TestUtils.generateTestData(output2, 48L);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        if (!this.equalFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.equalFile2 + " as the parent directory does not exist");
        }
        var3_3 = null;
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.equalFile2));){
            TestUtils.generateTestData(output1, 48L);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        if (!this.moreFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.moreFile + " as the parent directory does not exist");
        }
        var3_3 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.moreFile));){
            TestUtils.generateTestData(output, 48L);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void constructorIterable_order() {
        ArrayList<Comparator> list = new ArrayList<Comparator>();
        list.add(SizeFileComparator.SIZE_COMPARATOR);
        list.add(ExtensionFileComparator.EXTENSION_COMPARATOR);
        CompositeFileComparator c = new CompositeFileComparator(list);
        Assert.assertEquals((String)"equal", (long)0L, (long)c.compare(this.equalFile1, this.equalFile2));
        Assert.assertTrue((String)"less", (c.compare(this.lessFile, this.moreFile) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"more", (c.compare(this.moreFile, this.lessFile) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void constructorIterable_Null() {
        CompositeFileComparator c = new CompositeFileComparator((Iterable)null);
        Assert.assertEquals((String)"less,more", (long)0L, (long)c.compare(this.lessFile, this.moreFile));
        Assert.assertEquals((String)"more,less", (long)0L, (long)c.compare(this.moreFile, this.lessFile));
        Assert.assertEquals((String)"toString", (Object)"CompositeFileComparator{}", (Object)c.toString());
    }

    @Test
    public void constructorArray_Null() {
        CompositeFileComparator c = new CompositeFileComparator((Comparator[])null);
        Assert.assertEquals((String)"less,more", (long)0L, (long)c.compare(this.lessFile, this.moreFile));
        Assert.assertEquals((String)"more,less", (long)0L, (long)c.compare(this.moreFile, this.lessFile));
        Assert.assertEquals((String)"toString", (Object)"CompositeFileComparator{}", (Object)c.toString());
    }
}

