/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileCleaningTrackerTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File testFile;
    private FileCleaningTracker theInstance;

    private File getTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    protected FileCleaningTracker newInstance() {
        return new FileCleaningTracker();
    }

    @Before
    public void setUp() throws Exception {
        this.testFile = new File(this.getTestDirectory(), "file-test.txt");
        this.theInstance = this.newInstance();
    }

    @After
    public void tearDown() throws Exception {
        if (this.theInstance != null) {
            this.theInstance.q = new ReferenceQueue();
            this.theInstance.trackers.clear();
            this.theInstance.deleteFailures.clear();
            this.theInstance.exitWhenFinished = false;
            this.theInstance.reaper = null;
        }
        this.theInstance = null;
    }

    @Test
    public void testFileCleanerFile() throws Exception {
        String path = this.testFile.getPath();
        Assert.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        Assert.assertTrue((boolean)this.testFile.exists());
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        Assert.assertEquals((long)1L, (long)this.theInstance.getTrackCount());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        Assert.assertEquals((String)this.showFailures(), (Object)false, (Object)new File(path).exists());
    }

    @Test
    public void testFileCleanerDirectory() throws Exception {
        TestUtils.createFile(this.testFile, 100L);
        Assert.assertTrue((boolean)this.testFile.exists());
        Assert.assertTrue((boolean)this.getTestDirectory().exists());
        Object obj = new Object();
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        this.theInstance.track(this.getTestDirectory(), obj);
        Assert.assertEquals((long)1L, (long)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        Assert.assertTrue((boolean)this.testFile.exists());
        Assert.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    @Test
    public void testFileCleanerDirectory_NullStrategy() throws Exception {
        TestUtils.createFile(this.testFile, 100L);
        Assert.assertTrue((boolean)this.testFile.exists());
        Assert.assertTrue((boolean)this.getTestDirectory().exists());
        Object obj = new Object();
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        this.theInstance.track(this.getTestDirectory(), obj, null);
        Assert.assertEquals((long)1L, (long)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        Assert.assertTrue((boolean)this.testFile.exists());
        Assert.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    @Test
    public void testFileCleanerDirectory_ForceStrategy() throws Exception {
        if (!this.testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile));){
            TestUtils.generateTestData(output, 100L);
        }
        Assert.assertTrue((boolean)this.testFile.exists());
        Assert.assertTrue((boolean)this.getTestDirectory().exists());
        Object obj = new Object();
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        this.theInstance.track(this.getTestDirectory(), obj, FileDeleteStrategy.FORCE);
        Assert.assertEquals((long)1L, (long)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(this.testFile.getParentFile());
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        Assert.assertEquals((String)this.showFailures(), (Object)false, (Object)new File(this.testFile.getPath()).exists());
        Assert.assertEquals((String)this.showFailures(), (Object)false, (Object)this.testFile.getParentFile().exists());
    }

    @Test
    public void testFileCleanerNull() throws Exception {
        try {
            this.theInstance.track((File)null, new Object());
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.theInstance.track((File)null, new Object(), FileDeleteStrategy.NORMAL);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.theInstance.track((String)null, new Object());
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.theInstance.track((String)null, new Object(), FileDeleteStrategy.NORMAL);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFileCleanerExitWhenFinishedFirst() throws Exception {
        Assert.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        Assert.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assert.assertEquals(null, (Object)this.theInstance.reaper);
        this.waitUntilTrackCount();
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        Assert.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assert.assertEquals(null, (Object)this.theInstance.reaper);
    }

    @Test
    public void testFileCleanerExitWhenFinished_NoTrackAfter() throws Exception {
        Assert.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        Assert.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assert.assertEquals(null, (Object)this.theInstance.reaper);
        String path = this.testFile.getPath();
        Object marker = new Object();
        try {
            this.theInstance.track(path, marker);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assert.assertEquals(null, (Object)this.theInstance.reaper);
    }

    @Test
    public void testFileCleanerExitWhenFinished1() throws Exception {
        String path = this.testFile.getPath();
        Assert.assertEquals((String)("1-testFile exists: " + this.testFile), (Object)false, (Object)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        Assert.assertEquals((String)"2-testFile exists", (Object)true, (Object)this.testFile.exists());
        Assert.assertEquals((String)"3-Track Count", (long)0L, (long)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        Assert.assertEquals((String)"4-Track Count", (long)1L, (long)this.theInstance.getTrackCount());
        Assert.assertEquals((String)"5-exitWhenFinished", (Object)false, (Object)this.theInstance.exitWhenFinished);
        Assert.assertEquals((String)"6-reaper.isAlive", (Object)true, (Object)this.theInstance.reaper.isAlive());
        Assert.assertEquals((String)"7-exitWhenFinished", (Object)false, (Object)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        Assert.assertEquals((String)"8-exitWhenFinished", (Object)true, (Object)this.theInstance.exitWhenFinished);
        Assert.assertEquals((String)"9-reaper.isAlive", (Object)true, (Object)this.theInstance.reaper.isAlive());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assert.assertEquals((String)"10-Track Count", (long)0L, (long)this.theInstance.getTrackCount());
        Assert.assertEquals((String)("11-testFile exists " + this.showFailures()), (Object)false, (Object)new File(path).exists());
        Assert.assertEquals((String)"12-exitWhenFinished", (Object)true, (Object)this.theInstance.exitWhenFinished);
        Assert.assertEquals((String)"13-reaper.isAlive", (Object)false, (Object)this.theInstance.reaper.isAlive());
    }

    @Test
    public void testFileCleanerExitWhenFinished2() throws Exception {
        String path = this.testFile.getPath();
        Assert.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        Assert.assertTrue((boolean)this.testFile.exists());
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        Assert.assertEquals((long)1L, (long)this.theInstance.getTrackCount());
        Assert.assertFalse((boolean)this.theInstance.exitWhenFinished);
        Assert.assertTrue((boolean)this.theInstance.reaper.isAlive());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assert.assertEquals((long)0L, (long)this.theInstance.getTrackCount());
        Assert.assertEquals((String)this.showFailures(), (Object)false, (Object)new File(path).exists());
        Assert.assertFalse((boolean)this.theInstance.exitWhenFinished);
        Assert.assertTrue((boolean)this.theInstance.reaper.isAlive());
        Assert.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        for (int i = 0; i < 20 && this.theInstance.reaper.isAlive(); ++i) {
            TestUtils.sleep(500L);
        }
        Assert.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assert.assertFalse((boolean)this.theInstance.reaper.isAlive());
    }

    private void pauseForDeleteToComplete(File file) {
        int count = 0;
        while (file.exists() && count++ < 40) {
            try {
                TestUtils.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            file = new File(file.getPath());
        }
    }

    private String showFailures() throws Exception {
        if (this.theInstance.deleteFailures.size() == 1) {
            return "[Delete Failed: " + (String)this.theInstance.deleteFailures.get(0) + "]";
        }
        return "[Delete Failures: " + this.theInstance.deleteFailures.size() + "]";
    }

    private void waitUntilTrackCount() throws Exception {
        System.gc();
        TestUtils.sleep(500L);
        int count = 0;
        while (this.theInstance.getTrackCount() != 0 && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (this.theInstance.getTrackCount() != 0) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list = null;
            System.gc();
            TestUtils.sleep(1000L);
        }
        if (this.theInstance.getTrackCount() != 0) {
            throw new IllegalStateException("Your JVM is not releasing References, try running the testcase with less memory (-Xmx)");
        }
    }
}

