/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleBiFunction;
import org.apache.commons.geometry.core.Embedding;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Region;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Vector;
import org.apache.commons.geometry.euclidean.EuclideanVector;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.numbers.core.Precision;

public abstract class AbstractNSphere<V extends EuclideanVector<V>>
implements Region<V> {
    private final V center;
    private final double radius;
    private final Precision.DoubleEquivalence precision;

    protected AbstractNSphere(V center, double radius, Precision.DoubleEquivalence precision) {
        if (!center.isFinite()) {
            throw new IllegalArgumentException("Illegal center point: " + center);
        }
        if (!Double.isFinite(radius) || precision.lte(radius, 0.0)) {
            throw new IllegalArgumentException("Illegal radius: " + radius);
        }
        this.center = center;
        this.radius = radius;
        this.precision = precision;
    }

    public V getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public Precision.DoubleEquivalence getPrecision() {
        return this.precision;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public V getCentroid() {
        return this.getCenter();
    }

    public RegionLocation classify(V pt) {
        double dist = this.center.distance(pt);
        int cmp = this.precision.compare(dist, this.radius);
        if (cmp < 0) {
            return RegionLocation.INSIDE;
        }
        if (cmp > 0) {
            return RegionLocation.OUTSIDE;
        }
        return RegionLocation.BOUNDARY;
    }

    public int hashCode() {
        return Objects.hash(this.center, this.radius, this.precision);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractNSphere other = (AbstractNSphere)obj;
        return Objects.equals(this.center, other.center) && Double.compare(this.radius, other.radius) == 0 && Objects.equals(this.getPrecision(), other.getPrecision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append(this.getClass().getSimpleName()).append("[center= ").append(this.center).append(", radius= ").append(this.radius).append(']');
        return sb.toString();
    }

    protected V project(V pt, V defaultVector) {
        V vec = ((EuclideanVector)this.center).vectorTo(pt);
        if (vec.equals(vec.getZero())) {
            vec = defaultVector;
        }
        return (V)((EuclideanVector)((EuclideanVector)vec.withNorm(this.radius)).add((Vector)this.center));
    }

    protected <L extends Embedding<V, Vector1D>> List<V> intersections(L line, ToDoubleBiFunction<L, V> abscissaFn, ToDoubleBiFunction<L, V> distanceFn) {
        double dist = distanceFn.applyAsDouble(line, this.center);
        int cmp = this.precision.compare(dist, this.radius);
        if (cmp <= 0) {
            double abscissa = abscissaFn.applyAsDouble(line, this.center);
            double abscissaDelta = Math.sqrt(this.radius * this.radius - dist * dist);
            EuclideanVector p0 = (EuclideanVector)line.toSpace((Point)Vector1D.of(abscissa - abscissaDelta));
            if (cmp < 0) {
                EuclideanVector p1 = (EuclideanVector)line.toSpace((Point)Vector1D.of(abscissa + abscissaDelta));
                return Arrays.asList(p0, p1);
            }
            return Collections.singletonList(p0);
        }
        return Collections.emptyList();
    }

    protected <L extends Embedding<V, Vector1D>> V firstIntersection(L line, ToDoubleBiFunction<L, V> abscissaFn, ToDoubleBiFunction<L, V> distanceFn) {
        double dist = distanceFn.applyAsDouble(line, this.center);
        int cmp = this.precision.compare(dist, this.radius);
        if (cmp <= 0) {
            double abscissa = abscissaFn.applyAsDouble(line, this.center);
            double abscissaDelta = Math.sqrt(this.radius * this.radius - dist * dist);
            return (V)((EuclideanVector)line.toSpace((Point)Vector1D.of(abscissa - abscissaDelta)));
        }
        return null;
    }
}

