/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.enclosing.euclidean.threed;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.enclosing.EnclosingBall;
import org.apache.commons.geometry.enclosing.SupportBallGenerator;
import org.apache.commons.geometry.enclosing.euclidean.twod.DiskGenerator;
import org.apache.commons.geometry.euclidean.threed.EmbeddingPlane;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.fraction.BigFraction;

public class SphereGenerator
implements SupportBallGenerator<Vector3D> {
    private final DoublePrecisionContext precision;

    public SphereGenerator(DoublePrecisionContext precision) {
        this.precision = precision;
    }

    @Override
    public EnclosingBall<Vector3D> ballOnSupport(List<Vector3D> support) {
        if (support.isEmpty()) {
            return new EnclosingBall<Vector3D>(Vector3D.ZERO, Double.NEGATIVE_INFINITY, Collections.emptyList());
        }
        Vector3D vA = support.get(0);
        if (support.size() < 2) {
            return new EnclosingBall<Vector3D>(vA, 0.0, Collections.singletonList(vA));
        }
        Vector3D vB = support.get(1);
        if (support.size() < 3) {
            return new EnclosingBall<Vector3D>(Vector3D.linearCombination((double)0.5, (Vector3D)vA, (double)0.5, (Vector3D)vB), 0.5 * vA.distance(vB), Arrays.asList(vA, vB));
        }
        Vector3D vC = support.get(2);
        if (support.size() < 4) {
            EmbeddingPlane p = Planes.fromPoints((Vector3D)vA, (Vector3D)vB, (Vector3D)vC, (DoublePrecisionContext)this.precision).getEmbedding();
            EnclosingBall<Vector2D> disk = new DiskGenerator().ballOnSupport(Arrays.asList(p.toSubspace(vA), p.toSubspace(vB), p.toSubspace(vC)));
            return new EnclosingBall<Vector3D>(p.toSpace(disk.getCenter()), disk.getRadius(), Arrays.asList(vA, vB, vC));
        }
        Vector3D vD = support.get(3);
        BigFraction[] c2 = new BigFraction[]{BigFraction.from((double)vA.getX()), BigFraction.from((double)vB.getX()), BigFraction.from((double)vC.getX()), BigFraction.from((double)vD.getX())};
        BigFraction[] c3 = new BigFraction[]{BigFraction.from((double)vA.getY()), BigFraction.from((double)vB.getY()), BigFraction.from((double)vC.getY()), BigFraction.from((double)vD.getY())};
        BigFraction[] c4 = new BigFraction[]{BigFraction.from((double)vA.getZ()), BigFraction.from((double)vB.getZ()), BigFraction.from((double)vC.getZ()), BigFraction.from((double)vD.getZ())};
        BigFraction[] c1 = new BigFraction[]{c2[0].multiply(c2[0]).add(c3[0].multiply(c3[0])).add(c4[0].multiply(c4[0])), c2[1].multiply(c2[1]).add(c3[1].multiply(c3[1])).add(c4[1].multiply(c4[1])), c2[2].multiply(c2[2]).add(c3[2].multiply(c3[2])).add(c4[2].multiply(c4[2])), c2[3].multiply(c2[3]).add(c3[3].multiply(c3[3])).add(c4[3].multiply(c4[3]))};
        BigFraction twoM11 = this.minor(c2, c3, c4).multiply(2);
        BigFraction m12 = this.minor(c1, c3, c4);
        BigFraction m13 = this.minor(c1, c2, c4);
        BigFraction m14 = this.minor(c1, c2, c3);
        BigFraction centerX = m12.divide(twoM11);
        BigFraction centerY = m13.divide(twoM11).negate();
        BigFraction centerZ = m14.divide(twoM11);
        BigFraction dx = c2[0].subtract(centerX);
        BigFraction dy = c3[0].subtract(centerY);
        BigFraction dz = c4[0].subtract(centerZ);
        BigFraction r2 = dx.multiply(dx).add(dy.multiply(dy)).add(dz.multiply(dz));
        return new EnclosingBall<Vector3D>(Vector3D.of((double)centerX.doubleValue(), (double)centerY.doubleValue(), (double)centerZ.doubleValue()), Math.sqrt(r2.doubleValue()), Arrays.asList(vA, vB, vC, vD));
    }

    private BigFraction minor(BigFraction[] c1, BigFraction[] c2, BigFraction[] c3) {
        return c2[0].multiply(c3[1]).multiply(c1[2].subtract(c1[3])).add(c2[0].multiply(c3[2]).multiply(c1[3].subtract(c1[1]))).add(c2[0].multiply(c3[3]).multiply(c1[1].subtract(c1[2]))).add(c2[1].multiply(c3[0]).multiply(c1[3].subtract(c1[2]))).add(c2[1].multiply(c3[2]).multiply(c1[0].subtract(c1[3]))).add(c2[1].multiply(c3[3]).multiply(c1[2].subtract(c1[0]))).add(c2[2].multiply(c3[0]).multiply(c1[1].subtract(c1[3]))).add(c2[2].multiply(c3[1]).multiply(c1[3].subtract(c1[0]))).add(c2[2].multiply(c3[3]).multiply(c1[0].subtract(c1[1]))).add(c2[3].multiply(c3[0]).multiply(c1[2].subtract(c1[1]))).add(c2[3].multiply(c3[1]).multiply(c1[0].subtract(c1[2]))).add(c2[3].multiply(c3[2]).multiply(c1[1].subtract(c1[0])));
    }
}

