/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.enclosing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.internal.GeometryInternalError;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.enclosing.Encloser;
import org.apache.commons.geometry.enclosing.EnclosingBall;
import org.apache.commons.geometry.enclosing.SupportBallGenerator;

public class WelzlEncloser<P extends Point<P>>
implements Encloser<P> {
    private final DoublePrecisionContext precision;
    private final SupportBallGenerator<P> generator;

    public WelzlEncloser(SupportBallGenerator<P> generator, DoublePrecisionContext precision) {
        this.generator = generator;
        this.precision = precision;
    }

    @Override
    public EnclosingBall<P> enclose(Iterable<P> points) {
        if (points == null || !points.iterator().hasNext()) {
            throw new IllegalArgumentException("Unable to generate enclosing ball: no points given");
        }
        return this.pivotingBall(points);
    }

    private EnclosingBall<P> pivotingBall(Iterable<P> points) {
        Point first = (Point)points.iterator().next();
        ArrayList<Object> extreme = new ArrayList<Object>(first.getDimension() + 1);
        ArrayList<P> support = new ArrayList<P>(first.getDimension() + 1);
        extreme.add(first);
        EnclosingBall ball = this.moveToFrontBall(extreme, extreme.size(), support);
        P farthest;
        while (!ball.contains(farthest = this.selectFarthest(points, ball), this.precision)) {
            support.clear();
            support.add(farthest);
            EnclosingBall savedBall = ball;
            ball = this.moveToFrontBall(extreme, extreme.size(), support);
            if (this.precision.lt(ball.getRadius(), savedBall.getRadius())) {
                throw new GeometryInternalError();
            }
            extreme.add(0, farthest);
            extreme.subList(ball.getSupportSize(), extreme.size()).clear();
        }
        return ball;
    }

    private EnclosingBall<P> moveToFrontBall(List<P> extreme, int nbExtreme, List<P> support) {
        EnclosingBall<Point> ball = this.generator.ballOnSupport(support);
        if (ball.getSupportSize() <= ball.getCenter().getDimension()) {
            for (int i = 0; i < nbExtreme; ++i) {
                Point pi = (Point)extreme.get(i);
                if (ball.contains(pi, this.precision)) continue;
                support.add(pi);
                ball = this.moveToFrontBall(extreme, i, support);
                support.remove(support.size() - 1);
                for (int j = i; j > 0; --j) {
                    extreme.set(j, extreme.get(j - 1));
                }
                extreme.set(0, pi);
            }
        }
        return ball;
    }

    private P selectFarthest(Iterable<P> points, EnclosingBall<P> ball) {
        P center = ball.getCenter();
        Point farthest = null;
        double dMax = -1.0;
        for (Point point : points) {
            double d = point.distance(center);
            if (!(d > dMax)) continue;
            farthest = point;
            dMax = d;
        }
        return (P)farthest;
    }
}

