/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.Comparator;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.internal.SimpleTupleFormat;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.SphericalCoordinates;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.QuaternionRotation;

public final class Point2S
implements Point<Point2S> {
    public static final Point2S PLUS_I = new Point2S(0.0, 1.5707963267948966, Vector3D.Unit.PLUS_X);
    public static final Point2S PLUS_J = new Point2S(1.5707963267948966, 1.5707963267948966, Vector3D.Unit.PLUS_Y);
    public static final Point2S PLUS_K = new Point2S(0.0, 0.0, Vector3D.Unit.PLUS_Z);
    public static final Point2S MINUS_I = new Point2S(Math.PI, 1.5707963267948966, Vector3D.Unit.MINUS_X);
    public static final Point2S MINUS_J = new Point2S(4.71238898038469, 1.5707963267948966, Vector3D.Unit.MINUS_Y);
    public static final Point2S MINUS_K = new Point2S(0.0, Math.PI, Vector3D.Unit.MINUS_Z);
    public static final Point2S NaN = new Point2S(Double.NaN, Double.NaN, null);
    public static final Comparator<Point2S> POLAR_AZIMUTH_ASCENDING_ORDER = (a, b) -> {
        int cmp = 0;
        if (a != null && b != null) {
            cmp = Double.compare(a.getPolar(), b.getPolar());
            if (cmp == 0) {
                cmp = Double.compare(a.getAzimuth(), b.getAzimuth());
            }
        } else if (a != null) {
            cmp = -1;
        } else if (b != null) {
            cmp = 1;
        }
        return cmp;
    };
    private final double azimuth;
    private final double polar;
    private final Vector3D.Unit vector;

    private Point2S(double azimuth, double polar, Vector3D.Unit vector) {
        this.azimuth = SphericalCoordinates.normalizeAzimuth((double)azimuth);
        this.polar = SphericalCoordinates.normalizePolar((double)polar);
        this.vector = vector != null ? vector : Point2S.computeVector(azimuth, polar);
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getPolar() {
        return this.polar;
    }

    public Vector3D.Unit getVector() {
        return this.vector;
    }

    public int getDimension() {
        return 2;
    }

    public boolean isNaN() {
        return Double.isNaN(this.azimuth) || Double.isNaN(this.polar);
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.azimuth) || Double.isInfinite(this.polar));
    }

    public boolean isFinite() {
        return Double.isFinite(this.azimuth) && Double.isFinite(this.polar);
    }

    public Point2S antipodal() {
        return Point2S.from((Vector3D)this.vector.negate());
    }

    public double distance(Point2S point) {
        return Point2S.distance(this, point);
    }

    public Point2S slerp(Point2S other, double t) {
        QuaternionRotation start = QuaternionRotation.identity();
        QuaternionRotation end = QuaternionRotation.createVectorRotation((Vector3D)this.getVector(), (Vector3D)other.getVector());
        QuaternionRotation quat = (QuaternionRotation)start.slerp(end).apply(t);
        return Point2S.from(quat.apply((Vector3D)this.getVector()));
    }

    public boolean eq(Point2S point, DoublePrecisionContext precision) {
        return precision.eqZero(this.distance(point));
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 134 * (37 * Double.hashCode(this.azimuth) + Double.hashCode(this.polar));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Point2S)) {
            return false;
        }
        Point2S rhs = (Point2S)other;
        if (rhs.isNaN()) {
            return this.isNaN();
        }
        return Double.compare(this.azimuth, rhs.azimuth) == 0 && Double.compare(this.polar, rhs.polar) == 0;
    }

    public String toString() {
        return SimpleTupleFormat.getDefault().format(this.getAzimuth(), this.getPolar());
    }

    public static Point2S of(double azimuth, double polar) {
        return new Point2S(azimuth, polar, null);
    }

    public static Point2S from(Vector3D vector) {
        SphericalCoordinates coords = SphericalCoordinates.fromCartesian((Vector3D)vector);
        return new Point2S(coords.getAzimuth(), coords.getPolar(), vector.normalize());
    }

    public static Point2S parse(String str) {
        return (Point2S)SimpleTupleFormat.getDefault().parse(str, Point2S::of);
    }

    public static double distance(Point2S p1, Point2S p2) {
        return p1.vector.angle((Vector3D)p2.vector);
    }

    private static Vector3D.Unit computeVector(double azimuth, double polar) {
        if (Double.isFinite(azimuth) && Double.isFinite(polar)) {
            return SphericalCoordinates.toCartesian((double)1.0, (double)azimuth, (double)polar).normalize();
        }
        return null;
    }
}

