/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.List;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionEmbedding;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.internal.HyperplaneSubsets;
import org.apache.commons.geometry.core.partitioning.EmbeddingHyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.HyperplaneSubset;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.spherical.oned.Point1S;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatCircle;
import org.apache.commons.geometry.spherical.twod.Point2S;

public abstract class GreatCircleSubset
implements HyperplaneSubset<Point2S>,
RegionEmbedding<Point2S, Point1S> {
    private final GreatCircle circle;

    GreatCircleSubset(GreatCircle circle) {
        this.circle = circle;
    }

    public GreatCircle getCircle() {
        return this.circle;
    }

    public GreatCircle getHyperplane() {
        return this.getCircle();
    }

    public Point1S toSubspace(Point2S pt) {
        return this.circle.toSubspace(pt);
    }

    public Point2S toSpace(Point1S pt) {
        return this.circle.toSpace(pt);
    }

    public boolean isFull() {
        return this.getSubspaceRegion().isFull();
    }

    public boolean isEmpty() {
        return this.getSubspaceRegion().isEmpty();
    }

    public double getSize() {
        return this.getSubspaceRegion().getSize();
    }

    public Point2S getCentroid() {
        Point1S subspaceCentroid = (Point1S)this.getSubspaceRegion().getCentroid();
        if (subspaceCentroid != null) {
            return this.getCircle().toSpace(subspaceCentroid);
        }
        return null;
    }

    public RegionLocation classify(Point2S pt) {
        return HyperplaneSubsets.classifyAgainstEmbeddedRegion((Point)pt, (EmbeddingHyperplane)this.circle, this.getSubspaceRegion());
    }

    public Point2S closest(Point2S pt) {
        return (Point2S)HyperplaneSubsets.closestToEmbeddedRegion((Point)pt, (EmbeddingHyperplane)this.circle, this.getSubspaceRegion());
    }

    public abstract List<GreatArc> toConvex();

    public abstract HyperplaneBoundedRegion<Point1S> getSubspaceRegion();

    public DoublePrecisionContext getPrecision() {
        return this.circle.getPrecision();
    }
}

