/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.Objects;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.AbstractHyperplane;
import org.apache.commons.geometry.core.partitioning.EmbeddingHyperplane;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.spherical.oned.AngularInterval;
import org.apache.commons.geometry.spherical.oned.Point1S;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatCircles;
import org.apache.commons.geometry.spherical.twod.Point2S;

public final class GreatCircle
extends AbstractHyperplane<Point2S>
implements EmbeddingHyperplane<Point2S, Point1S> {
    private final Vector3D.Unit pole;
    private final Vector3D.Unit u;
    private final Vector3D.Unit v;

    GreatCircle(Vector3D.Unit pole, Vector3D.Unit u, Vector3D.Unit v, DoublePrecisionContext precision) {
        super(precision);
        this.pole = pole;
        this.u = u;
        this.v = v;
    }

    public Vector3D.Unit getPole() {
        return this.pole;
    }

    public Point2S getPolePoint() {
        return Point2S.from((Vector3D)this.pole);
    }

    public Vector3D.Unit getU() {
        return this.u;
    }

    public Vector3D.Unit getV() {
        return this.v;
    }

    public Vector3D.Unit getW() {
        return this.getPole();
    }

    public double offset(Point2S point) {
        return this.offset((Vector3D)point.getVector());
    }

    public double offset(Vector3D vec) {
        return this.pole.angle(vec) - 1.5707963267948966;
    }

    public double azimuth(Point2S pt) {
        return this.azimuth((Vector3D)pt.getVector());
    }

    public double azimuth(Vector3D vector) {
        double az = Math.atan2(vector.dot((Vector3D)this.v), vector.dot((Vector3D)this.u));
        if (az < 0.0) {
            az += Math.PI * 2;
        }
        return az;
    }

    public Vector3D vectorAt(double azimuth) {
        return Vector3D.linearCombination((double)Math.cos(azimuth), (Vector3D)this.u, (double)Math.sin(azimuth), (Vector3D)this.v);
    }

    public Point2S project(Point2S point) {
        double az = this.azimuth((Vector3D)point.getVector());
        return Point2S.from(this.vectorAt(az));
    }

    public GreatCircle reverse() {
        return new GreatCircle(this.pole.negate(), this.u, this.v.negate(), this.getPrecision());
    }

    public GreatCircle transform(Transform<Point2S> transform) {
        Point2S tu = (Point2S)transform.apply((Object)Point2S.from((Vector3D)this.u));
        Point2S tv = (Point2S)transform.apply((Object)Point2S.from((Vector3D)this.v));
        return GreatCircles.fromPoints(tu, tv, this.getPrecision());
    }

    public boolean similarOrientation(Hyperplane<Point2S> other) {
        GreatCircle otherCircle = (GreatCircle)other;
        return this.pole.dot((Vector3D)otherCircle.pole) > 0.0;
    }

    public GreatArc span() {
        return GreatCircles.arcFromInterval(this, AngularInterval.full());
    }

    public GreatArc arc(Point2S start, Point2S end) {
        return this.arc(this.toSubspace(start), this.toSubspace(end));
    }

    public GreatArc arc(Point1S start, Point1S end) {
        return this.arc(start.getAzimuth(), end.getAzimuth());
    }

    public GreatArc arc(double start, double end) {
        return this.arc(AngularInterval.Convex.of(start, end, this.getPrecision()));
    }

    public GreatArc arc(AngularInterval.Convex interval) {
        return GreatCircles.arcFromInterval(this, interval);
    }

    public Point2S intersection(GreatCircle other) {
        Vector3D cross = this.pole.cross((Vector3D)other.pole);
        if (!cross.eq(Vector3D.ZERO, this.getPrecision())) {
            return Point2S.from(cross);
        }
        return null;
    }

    public double angle(GreatCircle other) {
        return this.pole.angle((Vector3D)other.pole);
    }

    public double angle(GreatCircle other, Point2S pt) {
        double theta = this.angle(other);
        Vector3D cross = this.pole.cross((Vector3D)other.pole);
        return this.getPrecision().gt(pt.getVector().dot(cross), 0.0) ? theta : -theta;
    }

    public Point1S toSubspace(Point2S point) {
        return Point1S.of(this.azimuth((Vector3D)point.getVector()));
    }

    public Point2S toSpace(Point1S point) {
        return Point2S.from(this.vectorAt(point.getAzimuth()));
    }

    public boolean eq(GreatCircle other, DoublePrecisionContext precision) {
        return this.pole.eq((Vector3D)other.pole, precision) && this.u.eq((Vector3D)other.u, precision) && this.v.eq((Vector3D)other.v, precision);
    }

    public int hashCode() {
        return Objects.hash(this.pole, this.u, this.v, this.getPrecision());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GreatCircle)) {
            return false;
        }
        GreatCircle other = (GreatCircle)((Object)obj);
        return Objects.equals(this.pole, other.pole) && Objects.equals(this.u, other.u) && Objects.equals(this.v, other.v) && Objects.equals(this.getPrecision(), other.getPrecision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName()).append("[pole= ").append(this.pole).append(", u= ").append(this.u).append(", v= ").append(this.v).append(']');
        return sb.toString();
    }
}

