/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.Collections;
import java.util.List;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.SplitLocation;
import org.apache.commons.geometry.spherical.oned.AngularInterval;
import org.apache.commons.geometry.spherical.oned.CutAngle;
import org.apache.commons.geometry.spherical.oned.CutAngles;
import org.apache.commons.geometry.spherical.oned.Transform1S;
import org.apache.commons.geometry.spherical.twod.GreatCircle;
import org.apache.commons.geometry.spherical.twod.GreatCircleSubset;
import org.apache.commons.geometry.spherical.twod.GreatCircles;
import org.apache.commons.geometry.spherical.twod.Point2S;

public final class GreatArc
extends GreatCircleSubset
implements HyperplaneConvexSubset<Point2S> {
    private final AngularInterval.Convex interval;

    GreatArc(GreatCircle circle, AngularInterval.Convex interval) {
        super(circle);
        this.interval = interval;
    }

    public Point2S getStartPoint() {
        if (!this.interval.isFull()) {
            return this.getCircle().toSpace(this.interval.getMinBoundary().getPoint());
        }
        return null;
    }

    public Point2S getEndPoint() {
        if (!this.interval.isFull()) {
            return this.getCircle().toSpace(this.interval.getMaxBoundary().getPoint());
        }
        return null;
    }

    public Point2S getMidPoint() {
        if (!this.interval.isFull()) {
            return this.getCircle().toSpace(this.interval.getMidPoint());
        }
        return null;
    }

    public AngularInterval.Convex getInterval() {
        return this.interval;
    }

    public AngularInterval.Convex getSubspaceRegion() {
        return this.getInterval();
    }

    @Override
    public List<GreatArc> toConvex() {
        return Collections.singletonList(this);
    }

    public Split<GreatArc> split(Hyperplane<Point2S> splitter) {
        GreatCircle splitterCircle = (GreatCircle)splitter;
        GreatCircle thisCircle = this.getCircle();
        Point2S intersection = splitterCircle.intersection(thisCircle);
        GreatArc minus = null;
        GreatArc plus = null;
        if (intersection != null) {
            CutAngle subSplitter = CutAngles.createNegativeFacing(thisCircle.toSubspace(intersection), splitterCircle.getPrecision());
            Split<AngularInterval.Convex> subSplit = this.interval.splitDiameter(subSplitter);
            SplitLocation subLoc = subSplit.getLocation();
            if (subLoc == SplitLocation.MINUS) {
                minus = this;
            } else if (subLoc == SplitLocation.PLUS) {
                plus = this;
            } else if (subLoc == SplitLocation.BOTH) {
                minus = GreatCircles.arcFromInterval(thisCircle, (AngularInterval.Convex)subSplit.getMinus());
                plus = GreatCircles.arcFromInterval(thisCircle, (AngularInterval.Convex)subSplit.getPlus());
            }
        }
        return new Split(minus, plus);
    }

    public GreatArc transform(Transform<Point2S> transform) {
        return new GreatArc(this.getCircle().transform(transform), this.interval);
    }

    public GreatArc reverse() {
        return new GreatArc(this.getCircle().reverse(), (AngularInterval.Convex)this.interval.transform(Transform1S.createNegation()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        if (this.isFull()) {
            sb.append("full= true, circle= ").append((Object)this.getCircle());
        } else {
            sb.append("start= ").append(this.getStartPoint()).append(", end= ").append(this.getEndPoint());
        }
        return sb.toString();
    }
}

