/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.oned;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.HyperplaneSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.spherical.oned.AngularInterval;
import org.apache.commons.geometry.spherical.oned.CutAngle;
import org.apache.commons.geometry.spherical.oned.CutAngles;
import org.apache.commons.geometry.spherical.oned.Point1S;

public class RegionBSPTree1S
extends AbstractRegionBSPTree<Point1S, RegionNode1S> {
    private static final Comparator<BoundaryPair> BOUNDARY_PAIR_COMPARATOR = Comparator.comparingDouble(BoundaryPair::getMinValue);

    public RegionBSPTree1S() {
        this(false);
    }

    public RegionBSPTree1S(boolean full) {
        super(full);
    }

    public RegionBSPTree1S copy() {
        RegionBSPTree1S result = RegionBSPTree1S.empty();
        result.copy((BSPTree)this);
        return result;
    }

    public void add(AngularInterval interval) {
        this.union(RegionBSPTree1S.fromInterval(interval));
    }

    public Point1S project(Point1S pt) {
        BoundaryProjector1S projector = new BoundaryProjector1S(pt);
        this.accept((BSPTreeVisitor)projector);
        return (Point1S)projector.getProjected();
    }

    public void transform(Transform<Point1S> transform) {
        if (!this.isFull() && !this.isEmpty()) {
            List<AngularInterval> intervals = this.toIntervals();
            this.setEmpty();
            for (AngularInterval interval : intervals) {
                this.union(interval.transform(transform).toTree());
            }
        }
    }

    public Split<RegionBSPTree1S> split(Hyperplane<Point1S> splitter) {
        if (!this.isEmpty() && splitter.classify((Point)Point1S.ZERO) == HyperplaneLocation.ON) {
            CutAngle cut = (CutAngle)splitter;
            if (cut.isPositiveFacing()) {
                return new Split(null, (Object)this.copy());
            }
            return new Split((Object)this.copy(), null);
        }
        return this.split(splitter, RegionBSPTree1S.empty(), RegionBSPTree1S.empty());
    }

    public Split<RegionBSPTree1S> splitDiameter(CutAngle splitter) {
        CutAngle opposite = CutAngles.fromPointAndDirection(splitter.getPoint().antipodal(), !splitter.isPositiveFacing(), splitter.getPrecision());
        double plusPoleOffset = splitter.isPositiveFacing() ? 1.5707963267948966 : -1.5707963267948966;
        Point1S plusPole = Point1S.of(splitter.getAzimuth() + plusPoleOffset);
        boolean zeroOnPlusSide = splitter.getPrecision().lte(plusPole.distance(Point1S.ZERO), 1.5707963267948966);
        Split<RegionBSPTree1S> firstSplit = this.split((Hyperplane<Point1S>)splitter);
        Split<RegionBSPTree1S> secondSplit = this.split((Hyperplane<Point1S>)opposite);
        RegionBSPTree1S minus = RegionBSPTree1S.empty();
        RegionBSPTree1S plus = RegionBSPTree1S.empty();
        if (zeroOnPlusSide) {
            RegionBSPTree1S.safeUnion(plus, (RegionBSPTree1S)((Object)firstSplit.getPlus()));
            RegionBSPTree1S.safeUnion(plus, (RegionBSPTree1S)((Object)secondSplit.getPlus()));
            minus = (RegionBSPTree1S)((Object)firstSplit.getMinus());
            if (minus != null) {
                minus = (RegionBSPTree1S)((Object)minus.split((Hyperplane<Point1S>)opposite).getMinus());
            }
        } else {
            RegionBSPTree1S.safeUnion(minus, (RegionBSPTree1S)((Object)firstSplit.getMinus()));
            RegionBSPTree1S.safeUnion(minus, (RegionBSPTree1S)((Object)secondSplit.getMinus()));
            plus = (RegionBSPTree1S)((Object)firstSplit.getPlus());
            if (plus != null) {
                plus = (RegionBSPTree1S)((Object)plus.split((Hyperplane<Point1S>)opposite).getPlus());
            }
        }
        return new Split((Object)(minus != null && !minus.isEmpty() ? minus : null), plus != null && !plus.isEmpty() ? plus : null);
    }

    public List<AngularInterval> toIntervals() {
        if (this.isFull()) {
            return Collections.singletonList(AngularInterval.full());
        }
        ArrayList<BoundaryPair> insideBoundaryPairs = new ArrayList<BoundaryPair>();
        for (RegionNode1S node : this.nodes()) {
            if (!node.isInside()) continue;
            insideBoundaryPairs.add(this.getNodeBoundaryPair(node));
        }
        insideBoundaryPairs.sort(BOUNDARY_PAIR_COMPARATOR);
        int boundaryPairCount = insideBoundaryPairs.size();
        int startOffset = 0;
        if (boundaryPairCount > 1) {
            BoundaryPair current = null;
            BoundaryPair previous = (BoundaryPair)insideBoundaryPairs.get(boundaryPairCount - 1);
            for (int i = 0; i < boundaryPairCount; ++i) {
                current = (BoundaryPair)insideBoundaryPairs.get(i);
                if (!Objects.equals((Object)current.getMin(), (Object)previous.getMax())) {
                    startOffset = i;
                    break;
                }
                previous = current;
            }
        }
        ArrayList<AngularInterval> intervals = new ArrayList<AngularInterval>();
        BoundaryPair start = null;
        BoundaryPair end = null;
        BoundaryPair current = null;
        for (int i = 0; i < boundaryPairCount; ++i) {
            current = (BoundaryPair)insideBoundaryPairs.get((i + startOffset) % boundaryPairCount);
            if (start == null) {
                start = current;
                end = current;
                continue;
            }
            if (Objects.equals((Object)end.getMax(), (Object)current.getMin())) {
                end = current;
                continue;
            }
            intervals.add(this.createInterval(start, end));
            start = current;
            end = current;
        }
        if (start != null && end != null) {
            intervals.add(this.createInterval(start, end));
        }
        return intervals;
    }

    private AngularInterval createInterval(BoundaryPair start, BoundaryPair end) {
        DoublePrecisionContext precision;
        CutAngle min = start.getMin();
        CutAngle max = end.getMax();
        DoublePrecisionContext doublePrecisionContext = precision = min != null ? min.getPrecision() : max.getPrecision();
        if (min != null) {
            if (min.isPositiveFacing()) {
                min = min.reverse();
            }
        } else {
            min = CutAngles.createNegativeFacing(0.0, precision);
        }
        if (max != null) {
            if (!max.isPositiveFacing()) {
                max = max.reverse();
            }
        } else {
            max = CutAngles.createPositiveFacing(Math.PI * 2, precision);
        }
        return AngularInterval.of(min, max);
    }

    private BoundaryPair getNodeBoundaryPair(RegionNode1S node) {
        RegionNode1S parent;
        CutAngle min = null;
        CutAngle max = null;
        RegionNode1S child = node;
        while ((min == null || max == null) && (parent = (RegionNode1S)child.getParent()) != null) {
            CutAngle pt = (CutAngle)parent.getCutHyperplane();
            if (pt.isPositiveFacing() && child.isMinus() || !pt.isPositiveFacing() && child.isPlus()) {
                if (max == null) {
                    max = pt;
                }
            } else if (min == null) {
                min = pt;
            }
            child = parent;
        }
        return new BoundaryPair(min, max);
    }

    protected AbstractRegionBSPTree.RegionSizeProperties<Point1S> computeRegionSizeProperties() {
        if (this.isFull()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(Math.PI * 2, null);
        }
        if (this.isEmpty()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(0.0, null);
        }
        double size = 0.0;
        Vector2D scaledCentroidSum = Vector2D.ZERO;
        for (AngularInterval interval : this.toIntervals()) {
            double intervalSize = interval.getSize();
            size += intervalSize;
            scaledCentroidSum = scaledCentroidSum.add(interval.getCentroid().getVector().withNorm(intervalSize));
        }
        DoublePrecisionContext precision = ((CutAngle)((RegionNode1S)this.getRoot()).getCutHyperplane()).getPrecision();
        Point1S centroid = scaledCentroidSum.eq(Vector2D.ZERO, precision) ? null : Point1S.from(scaledCentroidSum);
        return new AbstractRegionBSPTree.RegionSizeProperties(size, (Point)centroid);
    }

    protected RegionNode1S createNode() {
        return new RegionNode1S((AbstractBSPTree)this);
    }

    public static RegionBSPTree1S empty() {
        return new RegionBSPTree1S(false);
    }

    public static RegionBSPTree1S full() {
        return new RegionBSPTree1S(true);
    }

    public static RegionBSPTree1S fromInterval(AngularInterval interval) {
        CutAngle minBoundary = interval.getMinBoundary();
        CutAngle maxBoundary = interval.getMaxBoundary();
        RegionBSPTree1S tree = RegionBSPTree1S.full();
        if (minBoundary != null) {
            tree.insert(minBoundary.span());
        }
        if (maxBoundary != null) {
            tree.insert(maxBoundary.span());
        }
        return tree;
    }

    private static void safeUnion(RegionBSPTree1S target, RegionBSPTree1S input) {
        if (input != null) {
            target.union(input);
        }
    }

    private static final class BoundaryProjector1S
    extends AbstractRegionBSPTree.BoundaryProjector<Point1S, RegionNode1S> {
        BoundaryProjector1S(Point1S point) {
            super((Point)point);
        }

        protected boolean isPossibleClosestCut(HyperplaneSubset<Point1S> cut, Point1S target, double minDist) {
            return true;
        }

        protected Point1S disambiguateClosestPoint(Point1S target, Point1S a, Point1S b) {
            return a.getNormalizedAzimuth() < b.getNormalizedAzimuth() ? a : b;
        }
    }

    private static final class BoundaryPair {
        private final CutAngle min;
        private final CutAngle max;

        BoundaryPair(CutAngle min, CutAngle max) {
            this.min = min;
            this.max = max;
        }

        public CutAngle getMin() {
            return this.min;
        }

        public CutAngle getMax() {
            return this.max;
        }

        public double getMinValue() {
            return this.min != null ? this.min.getNormalizedAzimuth() : 0.0;
        }
    }

    public static final class RegionNode1S
    extends AbstractRegionBSPTree.AbstractRegionNode<Point1S, RegionNode1S> {
        private RegionNode1S(AbstractBSPTree<Point1S, RegionNode1S> tree) {
            super(tree);
        }

        protected RegionNode1S getSelf() {
            return this;
        }
    }
}

