/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.hull.euclidean.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.hull.euclidean.twod.AbstractConvexHullGenerator2D;

public class MonotoneChain
extends AbstractConvexHullGenerator2D {
    public MonotoneChain(DoublePrecisionContext precision) {
        this(false, precision);
    }

    public MonotoneChain(boolean includeCollinearPoints, DoublePrecisionContext precision) {
        super(includeCollinearPoints, precision);
    }

    @Override
    public Collection<Vector2D> findHullVertices(Collection<Vector2D> points) {
        int idx;
        ArrayList<Vector2D> pointsSortedByXAxis = new ArrayList<Vector2D>(points);
        pointsSortedByXAxis.sort((o1, o2) -> {
            DoublePrecisionContext precision = this.getPrecision();
            int cmp = precision.compare(o1.getX(), o2.getX());
            if (cmp == 0) {
                return precision.compare(o1.getY(), o2.getY());
            }
            return cmp;
        });
        ArrayList<Vector2D> lowerHull = new ArrayList<Vector2D>();
        for (Vector2D p : pointsSortedByXAxis) {
            this.updateHull(p, lowerHull);
        }
        ArrayList<Vector2D> upperHull = new ArrayList<Vector2D>();
        for (int idx2 = pointsSortedByXAxis.size() - 1; idx2 >= 0; --idx2) {
            Vector2D p = (Vector2D)pointsSortedByXAxis.get(idx2);
            this.updateHull(p, upperHull);
        }
        ArrayList<Vector2D> hullVertices = new ArrayList<Vector2D>(lowerHull.size() + upperHull.size() - 2);
        for (idx = 0; idx < lowerHull.size() - 1; ++idx) {
            hullVertices.add((Vector2D)lowerHull.get(idx));
        }
        for (idx = 0; idx < upperHull.size() - 1; ++idx) {
            hullVertices.add((Vector2D)upperHull.get(idx));
        }
        if (hullVertices.isEmpty() && !lowerHull.isEmpty()) {
            hullVertices.add((Vector2D)lowerHull.get(0));
        }
        return hullVertices;
    }

    private void updateHull(Vector2D point, List<Vector2D> hull) {
        Vector2D p1;
        DoublePrecisionContext precision = this.getPrecision();
        if (hull.size() == 1 && (p1 = hull.get(0)).eq(point, precision)) {
            return;
        }
        while (hull.size() >= 2) {
            Vector2D p2;
            int size = hull.size();
            Vector2D p12 = hull.get(size - 2);
            double offset = Lines.fromPoints((Vector2D)p12, (Vector2D)(p2 = hull.get(size - 1)), (DoublePrecisionContext)precision).offset(point);
            if (precision.eqZero(offset)) {
                double distanceToCurrent = p12.distance(point);
                if (precision.eqZero(distanceToCurrent) || precision.eqZero(p2.distance(point))) {
                    return;
                }
                double distanceToLast = p12.distance(p2);
                if (this.isIncludeCollinearPoints()) {
                    int index = distanceToCurrent < distanceToLast ? size - 1 : size;
                    hull.add(index, point);
                } else if (distanceToCurrent > distanceToLast) {
                    hull.remove(size - 1);
                    hull.add(point);
                }
                return;
            }
            if (!(offset > 0.0)) break;
            hull.remove(size - 1);
        }
        hull.add(point);
    }
}

