/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.hull.euclidean.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;
import org.apache.commons.geometry.hull.ConvexHull;

public final class ConvexHull2D
implements ConvexHull<Vector2D> {
    private final List<Vector2D> vertices;
    private final LinePath path;

    ConvexHull2D(Collection<Vector2D> vertices, DoublePrecisionContext precision) {
        this.vertices = Collections.unmodifiableList(new ArrayList<Vector2D>(vertices));
        this.path = ConvexHull2D.buildHullPath(vertices, precision);
    }

    @Override
    public List<Vector2D> getVertices() {
        return this.vertices;
    }

    public LinePath getPath() {
        return this.path;
    }

    public ConvexArea getRegion() {
        return this.path.isClosed() ? ConvexArea.convexPolygonFromPath((LinePath)this.path) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[vertices= ").append(this.getVertices()).append(']');
        return sb.toString();
    }

    private static LinePath buildHullPath(Collection<Vector2D> vertices, DoublePrecisionContext precision) {
        if (vertices.size() < 2) {
            return LinePath.empty();
        }
        boolean closeLoop = vertices.size() > 2;
        return LinePath.builder((DoublePrecisionContext)precision).appendVertices(vertices).build(closeLoop);
    }
}

