/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.hull.euclidean.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

public final class AklToussaintHeuristic {
    private AklToussaintHeuristic() {
    }

    public static Collection<Vector2D> reducePoints(Collection<Vector2D> points) {
        int size = 0;
        Vector2D minX = null;
        Vector2D maxX = null;
        Vector2D minY = null;
        Vector2D maxY = null;
        for (Vector2D p : points) {
            if (minX == null || p.getX() < minX.getX()) {
                minX = p;
            }
            if (maxX == null || p.getX() > maxX.getX()) {
                maxX = p;
            }
            if (minY == null || p.getY() < minY.getY()) {
                minY = p;
            }
            if (maxY == null || p.getY() > maxY.getY()) {
                maxY = p;
            }
            ++size;
        }
        if (size < 4) {
            return points;
        }
        List<Vector2D> quadrilateral = AklToussaintHeuristic.buildQuadrilateral(minY, maxX, maxY, minX);
        if (quadrilateral.size() < 3) {
            return points;
        }
        ArrayList<Vector2D> reducedPoints = new ArrayList<Vector2D>(quadrilateral);
        for (Vector2D p : points) {
            if (AklToussaintHeuristic.insideQuadrilateral(p, quadrilateral)) continue;
            reducedPoints.add(p);
        }
        return reducedPoints;
    }

    private static List<Vector2D> buildQuadrilateral(Vector2D ... points) {
        ArrayList<Vector2D> quadrilateral = new ArrayList<Vector2D>();
        for (Vector2D p : points) {
            if (quadrilateral.contains(p)) continue;
            quadrilateral.add(p);
        }
        return quadrilateral;
    }

    private static boolean insideQuadrilateral(Vector2D point, List<Vector2D> quadrilateralPoints) {
        Vector2D v1 = quadrilateralPoints.get(0);
        Vector2D v2 = quadrilateralPoints.get(1);
        if (point.equals((Object)v1) || point.equals((Object)v2)) {
            return true;
        }
        double last = AklToussaintHeuristic.signedAreaPoints(v1, v2, point);
        int size = quadrilateralPoints.size();
        for (int i = 1; i < size; ++i) {
            v1 = v2;
            v2 = quadrilateralPoints.get(i + 1 == size ? 0 : i + 1);
            if (point.equals((Object)v1) || point.equals((Object)v2)) {
                return true;
            }
            if (!(last * AklToussaintHeuristic.signedAreaPoints(v1, v2, point) < 0.0)) continue;
            return false;
        }
        return true;
    }

    private static double signedAreaPoints(Vector2D p0, Vector2D p1, Vector2D p2) {
        return p0.vectorTo(p1).signedArea(p0.vectorTo(p2));
    }
}

