/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.hull.euclidean.twod;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.hull.euclidean.twod.ConvexHull2D;
import org.apache.commons.geometry.hull.euclidean.twod.ConvexHullGenerator2D;

abstract class AbstractConvexHullGenerator2D
implements ConvexHullGenerator2D {
    private final DoublePrecisionContext precision;
    private final boolean includeCollinearPoints;

    protected AbstractConvexHullGenerator2D(boolean includeCollinearPoints, DoublePrecisionContext precision) {
        this.includeCollinearPoints = includeCollinearPoints;
        this.precision = precision;
    }

    public DoublePrecisionContext getPrecision() {
        return this.precision;
    }

    public boolean isIncludeCollinearPoints() {
        return this.includeCollinearPoints;
    }

    @Override
    public ConvexHull2D generate(Collection<Vector2D> points) {
        Collection<Vector2D> hullVertices = null;
        hullVertices = points.size() < 2 ? points : this.findHullVertices(points);
        if (!this.isConvex(hullVertices)) {
            throw new IllegalStateException("Convex hull algorithm failed to generate solution");
        }
        return new ConvexHull2D(hullVertices, this.precision);
    }

    protected abstract Collection<Vector2D> findHullVertices(Collection<Vector2D> var1);

    private boolean isConvex(Collection<Vector2D> vertices) {
        int size = vertices.size();
        if (size < 3) {
            return true;
        }
        Iterator<Vector2D> it = vertices.iterator();
        Vector2D p1 = it.next();
        Vector2D p2 = it.next();
        while (it.hasNext()) {
            Vector2D v2;
            Vector2D p3 = it.next();
            Vector2D v1 = p1.vectorTo(p2);
            if (this.precision.compare(v1.signedArea(v2 = p2.vectorTo(p3)), 0.0) < 0) {
                return false;
            }
            p1 = p2;
            p2 = p3;
        }
        return true;
    }
}

