/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod.shape;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutRule;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.AbstractNSphere;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.LinecastPoint2D;
import org.apache.commons.geometry.euclidean.twod.Linecastable2D;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.PolarCoordinates;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

public final class Circle
extends AbstractNSphere<Vector2D>
implements Linecastable2D {
    private Circle(Vector2D center, double radius, DoublePrecisionContext precision) {
        super(center, radius, precision);
    }

    public double getSize() {
        double r = this.getRadius();
        return Math.PI * r * r;
    }

    public double getBoundarySize() {
        return Math.PI * 2 * this.getRadius();
    }

    public Vector2D project(Vector2D pt) {
        return this.project(pt, Vector2D.Unit.PLUS_X);
    }

    public RegionBSPTree2D toTree(int segments) {
        return new CircleApproximationBuilder(this, segments).build();
    }

    public List<Vector2D> intersections(Line line) {
        return this.intersections(line, Line::abscissa, Line::distance);
    }

    public Vector2D firstIntersection(Line line) {
        return this.firstIntersection(line, Line::abscissa, Line::distance);
    }

    @Override
    public List<LinecastPoint2D> linecast(LineConvexSubset segment) {
        return this.getLinecastStream(segment).collect(Collectors.toList());
    }

    @Override
    public LinecastPoint2D linecastFirst(LineConvexSubset segment) {
        return this.getLinecastStream(segment).findFirst().orElse(null);
    }

    private Stream<LinecastPoint2D> getLinecastStream(LineConvexSubset segment) {
        return this.intersections(segment.getLine()).stream().filter(arg_0 -> ((LineConvexSubset)segment).contains(arg_0)).map(pt -> new LinecastPoint2D((Vector2D)pt, ((Vector2D)this.getCenter()).directionTo((Vector2D)pt), segment.getLine()));
    }

    public static Circle from(Vector2D center, double radius, DoublePrecisionContext precision) {
        return new Circle(center, radius, precision);
    }

    private static class CircleApproximationBuilder {
        private static final int MIN_SEGMENTS = 3;
        private static final int SPLIT_THRESHOLD = 4;
        private final Circle circle;
        private final int segments;
        private final double angleDelta;

        CircleApproximationBuilder(Circle circle, int segments) {
            if (segments < 3) {
                throw new IllegalArgumentException(MessageFormat.format("Circle approximation segment number must be greater than or equal to {0}; was {1}", 3, segments));
            }
            this.circle = circle;
            this.segments = segments;
            this.angleDelta = Math.PI * 2 / (double)segments;
        }

        public RegionBSPTree2D build() {
            RegionBSPTree2D tree = RegionBSPTree2D.empty();
            RegionBSPTree2D.RegionNode2D root = (RegionBSPTree2D.RegionNode2D)tree.getRoot();
            if (this.segments < 4) {
                this.insert(root, 0, this.segments);
            } else {
                int splitIdx = this.segments / 2;
                Vector2D p0 = this.pointAt(0);
                Vector2D p1 = this.pointAt(splitIdx);
                root.cut((Hyperplane)Lines.fromPoints(p0, p1, this.circle.getPrecision()), RegionCutRule.INHERIT);
                this.splitAndInsert((RegionBSPTree2D.RegionNode2D)root.getPlus(), 0, splitIdx);
                this.splitAndInsert((RegionBSPTree2D.RegionNode2D)root.getMinus(), splitIdx, this.segments);
            }
            return tree;
        }

        private void splitAndInsert(RegionBSPTree2D.RegionNode2D node, int startIdx, int stopIdx) {
            if (stopIdx - startIdx >= 4) {
                int splitIdx = (stopIdx - startIdx + 1) / 2 + startIdx;
                Vector2D p0 = (Vector2D)this.circle.getCenter();
                Vector2D p1 = this.pointAt(splitIdx);
                node.cut((Hyperplane)Lines.fromPoints(p0, p1, this.circle.getPrecision()), RegionCutRule.INHERIT);
                this.splitAndInsert((RegionBSPTree2D.RegionNode2D)node.getPlus(), startIdx, splitIdx);
                this.splitAndInsert((RegionBSPTree2D.RegionNode2D)node.getMinus(), splitIdx, stopIdx);
            } else {
                this.insert(node, startIdx, stopIdx);
            }
        }

        private void insert(RegionBSPTree2D.RegionNode2D node, int startIdx, int stopIdx) {
            RegionBSPTree2D.RegionNode2D currNode = node;
            Vector2D prevPt = this.pointAt(startIdx);
            for (int i = startIdx + 1; i <= stopIdx; ++i) {
                Vector2D currPt = this.pointAt(i);
                currNode = (RegionBSPTree2D.RegionNode2D)((RegionBSPTree2D.RegionNode2D)currNode.cut((Hyperplane)Lines.fromPoints(prevPt, currPt, this.circle.getPrecision()))).getMinus();
                prevPt = currPt;
            }
        }

        private Vector2D pointAt(int idx) {
            return PolarCoordinates.toCartesian(this.circle.getRadius(), (double)idx * this.angleDelta).add((Vector2D)this.circle.getCenter());
        }
    }
}

