/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

public final class Segment
extends LineConvexSubset {
    private final Vector2D startPoint;
    private final Vector2D endPoint;

    Segment(Line line, Vector2D startPoint, Vector2D endPoint) {
        super(line);
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isInfinite() {
        return false;
    }

    public boolean isFinite() {
        return true;
    }

    public double getSize() {
        return this.startPoint.distance(this.endPoint);
    }

    public Vector2D getCentroid() {
        return this.startPoint.lerp(this.endPoint, 0.5);
    }

    @Override
    public Vector2D getStartPoint() {
        return this.startPoint;
    }

    @Override
    public double getSubspaceStart() {
        return this.getLine().abscissa(this.startPoint);
    }

    @Override
    public Vector2D getEndPoint() {
        return this.endPoint;
    }

    @Override
    public double getSubspaceEnd() {
        return this.getLine().abscissa(this.endPoint);
    }

    @Override
    public Bounds2D getBounds() {
        return Bounds2D.builder().add(this.startPoint).add(this.endPoint).build();
    }

    @Override
    public Segment transform(Transform<Vector2D> transform) {
        Vector2D t1 = (Vector2D)transform.apply((Object)this.getStartPoint());
        Vector2D t2 = (Vector2D)transform.apply((Object)this.getEndPoint());
        Line tLine = this.getLine().transform(transform);
        return new Segment(tLine, t1, t2);
    }

    @Override
    public Segment reverse() {
        return new Segment(this.getLine().reverse(), this.endPoint, this.startPoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[startPoint= ").append(this.getStartPoint()).append(", endPoint= ").append(this.getEndPoint()).append(']');
        return sb.toString();
    }

    @Override
    RegionLocation classifyAbscissa(double abscissa) {
        DoublePrecisionContext precision = this.getPrecision();
        int startCmp = precision.compare(abscissa, this.getSubspaceStart());
        if (startCmp > 0) {
            int endCmp = precision.compare(abscissa, this.getSubspaceEnd());
            if (endCmp < 0) {
                return RegionLocation.INSIDE;
            }
            if (endCmp == 0) {
                return RegionLocation.BOUNDARY;
            }
        } else if (startCmp == 0) {
            return RegionLocation.BOUNDARY;
        }
        return RegionLocation.OUTSIDE;
    }

    @Override
    double closestAbscissa(double abscissa) {
        return Math.max(this.getSubspaceStart(), Math.min(this.getSubspaceEnd(), abscissa));
    }

    @Override
    Split<LineConvexSubset> splitOnIntersection(Line splitter, Vector2D intersection) {
        Line line = this.getLine();
        DoublePrecisionContext splitterPrecision = splitter.getPrecision();
        int startCmp = splitterPrecision.compare(splitter.offset(this.startPoint), 0.0);
        int endCmp = splitterPrecision.compare(splitter.offset(this.endPoint), 0.0);
        if (startCmp == 0 && endCmp == 0) {
            return new Split(null, null);
        }
        if (startCmp < 1 && endCmp < 1) {
            return new Split((Object)this, null);
        }
        if (startCmp > -1 && endCmp > -1) {
            return new Split(null, (Object)this);
        }
        Segment startSegment = new Segment(line, this.startPoint, intersection);
        Segment endSegment = new Segment(line, intersection, this.endPoint);
        Segment minus = startCmp > 0 ? endSegment : startSegment;
        Segment plus = startCmp > 0 ? startSegment : endSegment;
        return new Split((Object)minus, (Object)plus);
    }
}

