/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Ray;
import org.apache.commons.geometry.euclidean.twod.Segment;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

public final class ReverseRay
extends LineConvexSubset {
    private final Vector2D endPoint;

    ReverseRay(Line line, Vector2D endPoint) {
        super(line);
        this.endPoint = endPoint;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isInfinite() {
        return true;
    }

    public boolean isFinite() {
        return false;
    }

    public double getSize() {
        return Double.POSITIVE_INFINITY;
    }

    public Vector2D getCentroid() {
        return null;
    }

    @Override
    public Vector2D getStartPoint() {
        return null;
    }

    @Override
    public double getSubspaceStart() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Vector2D getEndPoint() {
        return this.endPoint;
    }

    @Override
    public double getSubspaceEnd() {
        return this.getLine().abscissa(this.endPoint);
    }

    @Override
    public Bounds2D getBounds() {
        return null;
    }

    @Override
    public ReverseRay transform(Transform<Vector2D> transform) {
        Line tLine = this.getLine().transform(transform);
        Vector2D tEnd = (Vector2D)transform.apply((Object)this.getEndPoint());
        return new ReverseRay(tLine, tEnd);
    }

    @Override
    public Ray reverse() {
        return new Ray(this.getLine().reverse(), this.endPoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[direction= ").append(this.getLine().getDirection()).append(", endPoint= ").append(this.getEndPoint()).append(']');
        return sb.toString();
    }

    @Override
    RegionLocation classifyAbscissa(double abscissa) {
        int cmp = this.getPrecision().compare(abscissa, this.getSubspaceEnd());
        if (cmp < 0) {
            return RegionLocation.INSIDE;
        }
        if (cmp == 0) {
            return RegionLocation.BOUNDARY;
        }
        return RegionLocation.OUTSIDE;
    }

    @Override
    double closestAbscissa(double abscissa) {
        return Math.min(this.getSubspaceEnd(), abscissa);
    }

    @Override
    protected Split<LineConvexSubset> splitOnIntersection(Line splitter, Vector2D intersection) {
        boolean pointsTowardPlus;
        Line line = this.getLine();
        DoublePrecisionContext splitterPrecision = splitter.getPrecision();
        int endCmp = splitterPrecision.compare(splitter.offset(this.endPoint), 0.0);
        boolean bl = pointsTowardPlus = splitter.getOffsetDirection().dot(line.getDirection()) >= 0.0;
        if (pointsTowardPlus && endCmp < 1) {
            return new Split((Object)this, null);
        }
        if (!pointsTowardPlus && endCmp > -1) {
            return new Split(null, (Object)this);
        }
        Segment splitSeg = new Segment(line, intersection, this.endPoint);
        ReverseRay splitRevRay = new ReverseRay(line, intersection);
        LineConvexSubset minus = endCmp > 0 ? splitRevRay : splitSeg;
        LineConvexSubset plus = endCmp > 0 ? splitSeg : splitRevRay;
        return new Split((Object)minus, (Object)plus);
    }
}

