/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.ReverseRay;
import org.apache.commons.geometry.euclidean.twod.Segment;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

public final class Ray
extends LineConvexSubset {
    private final Vector2D startPoint;

    Ray(Line line, Vector2D startPoint) {
        super(line);
        this.startPoint = startPoint;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isInfinite() {
        return true;
    }

    public boolean isFinite() {
        return false;
    }

    public double getSize() {
        return Double.POSITIVE_INFINITY;
    }

    public Vector2D getCentroid() {
        return null;
    }

    @Override
    public Vector2D getStartPoint() {
        return this.startPoint;
    }

    @Override
    public double getSubspaceStart() {
        return this.getLine().abscissa(this.startPoint);
    }

    @Override
    public Vector2D getEndPoint() {
        return null;
    }

    @Override
    public double getSubspaceEnd() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Bounds2D getBounds() {
        return null;
    }

    public Vector2D getDirection() {
        return this.getLine().getDirection();
    }

    @Override
    public Ray transform(Transform<Vector2D> transform) {
        Line tLine = this.getLine().transform(transform);
        Vector2D tStart = (Vector2D)transform.apply((Object)this.getStartPoint());
        return new Ray(tLine, tStart);
    }

    @Override
    public ReverseRay reverse() {
        return new ReverseRay(this.getLine().reverse(), this.startPoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[startPoint= ").append(this.getStartPoint()).append(", direction= ").append(this.getLine().getDirection()).append(']');
        return sb.toString();
    }

    @Override
    RegionLocation classifyAbscissa(double abscissa) {
        int cmp = this.getPrecision().compare(abscissa, this.getSubspaceStart());
        if (cmp > 0) {
            return RegionLocation.INSIDE;
        }
        if (cmp == 0) {
            return RegionLocation.BOUNDARY;
        }
        return RegionLocation.OUTSIDE;
    }

    @Override
    double closestAbscissa(double abscissa) {
        return Math.max(this.getSubspaceStart(), abscissa);
    }

    @Override
    Split<LineConvexSubset> splitOnIntersection(Line splitter, Vector2D intersection) {
        boolean pointsTowardPlus;
        Line line = this.getLine();
        DoublePrecisionContext splitterPrecision = splitter.getPrecision();
        int startCmp = splitterPrecision.compare(splitter.offset(this.startPoint), 0.0);
        boolean bl = pointsTowardPlus = splitter.getOffsetDirection().dot(line.getDirection()) >= 0.0;
        if (pointsTowardPlus && startCmp > -1) {
            return new Split(null, (Object)this);
        }
        if (!pointsTowardPlus && startCmp < 1) {
            return new Split((Object)this, null);
        }
        Segment splitSeg = new Segment(line, this.startPoint, intersection);
        Ray splitRay = new Ray(line, intersection);
        LineConvexSubset minus = startCmp > 0 ? splitRay : splitSeg;
        LineConvexSubset plus = startCmp > 0 ? splitSeg : splitRay;
        return new Split((Object)minus, (Object)plus);
    }
}

