/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.text.MessageFormat;
import java.util.Objects;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.AbstractHyperplane;
import org.apache.commons.geometry.core.partitioning.EmbeddingHyperplane;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.oned.AffineTransformMatrix1D;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.Ray;
import org.apache.commons.geometry.euclidean.twod.ReverseRay;
import org.apache.commons.geometry.euclidean.twod.Segment;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.angle.PlaneAngleRadians;
import org.apache.commons.numbers.arrays.LinearCombination;

public final class Line
extends AbstractHyperplane<Vector2D>
implements EmbeddingHyperplane<Vector2D, Vector1D> {
    static final String TO_STRING_FORMAT = "{0}[origin= {1}, direction= {2}]";
    private final Vector2D.Unit direction;
    private final double originOffset;

    Line(Vector2D.Unit direction, double originOffset, DoublePrecisionContext precision) {
        super(precision);
        this.direction = direction;
        this.originOffset = originOffset;
    }

    public double getAngle() {
        double angle = Math.atan2(this.direction.getY(), this.direction.getX());
        return PlaneAngleRadians.normalizeBetweenZeroAndTwoPi((double)angle);
    }

    public Vector2D.Unit getDirection() {
        return this.direction;
    }

    public Vector2D getOffsetDirection() {
        return Vector2D.of(this.direction.getY(), -this.direction.getX());
    }

    public Vector2D getOrigin() {
        return this.toSpace(Vector1D.ZERO);
    }

    public double getOriginOffset() {
        return this.originOffset;
    }

    public Line reverse() {
        return new Line(this.direction.negate(), -this.originOffset, this.getPrecision());
    }

    public Line transform(Transform<Vector2D> transform) {
        Vector2D origin = this.getOrigin();
        Vector2D tOrigin = (Vector2D)transform.apply((Object)origin);
        Vector2D tOriginPlusDir = (Vector2D)transform.apply((Object)origin.add(this.getDirection()));
        return Lines.fromPoints(tOrigin, tOriginPlusDir, this.getPrecision());
    }

    public SubspaceTransform subspaceTransform(Transform<Vector2D> transform) {
        Vector2D origin = this.getOrigin();
        Vector2D p1 = (Vector2D)transform.apply((Object)origin);
        Vector2D p2 = (Vector2D)transform.apply((Object)origin.add(this.direction));
        Line tLine = Lines.fromPoints(p1, p2, this.getPrecision());
        Vector1D tSubspaceOrigin = tLine.toSubspace(p1);
        Vector1D tSubspaceDirection = tSubspaceOrigin.vectorTo(tLine.toSubspace(p2));
        double translation = tSubspaceOrigin.getX();
        double scale = tSubspaceDirection.getX();
        AffineTransformMatrix1D subspaceTransform = AffineTransformMatrix1D.of(scale, translation);
        return new SubspaceTransform(tLine, subspaceTransform);
    }

    public LineConvexSubset span() {
        return Lines.span(this);
    }

    public Segment segment(double a, double b) {
        return Lines.segmentFromLocations(this, a, b);
    }

    public Segment segment(Vector2D a, Vector2D b) {
        return Lines.segmentFromPoints(this, a, b);
    }

    public ReverseRay reverseRayTo(Vector2D endPoint) {
        return Lines.reverseRayFromPoint(this, endPoint);
    }

    public ReverseRay reverseRayTo(double endLocation) {
        return Lines.reverseRayFromLocation(this, endLocation);
    }

    public Ray rayFrom(Vector2D startPoint) {
        return Lines.rayFromPoint(this, startPoint);
    }

    public Ray rayFrom(double startLocation) {
        return Lines.rayFromLocation(this, startLocation);
    }

    public double abscissa(Vector2D point) {
        return this.direction.dot(point);
    }

    public Vector1D toSubspace(Vector2D point) {
        return Vector1D.of(this.abscissa(point));
    }

    public Vector2D toSpace(Vector1D point) {
        return this.toSpace(point.getX());
    }

    public Vector2D toSpace(double abscissa) {
        return Vector2D.of(LinearCombination.value((double)abscissa, (double)this.direction.getX(), (double)(-this.originOffset), (double)this.direction.getY()), LinearCombination.value((double)abscissa, (double)this.direction.getY(), (double)this.originOffset, (double)this.direction.getX()));
    }

    public Vector2D intersection(Line other) {
        double area = this.direction.signedArea(other.direction);
        if (this.getPrecision().eqZero(area)) {
            return null;
        }
        double x = LinearCombination.value((double)other.direction.getX(), (double)this.originOffset, (double)(-this.direction.getX()), (double)other.originOffset) / area;
        double y = LinearCombination.value((double)other.direction.getY(), (double)this.originOffset, (double)(-this.direction.getY()), (double)other.originOffset) / area;
        return Vector2D.of(x, y);
    }

    public double angle(Line other) {
        double thisAngle = Math.atan2(this.direction.getY(), this.direction.getX());
        double otherAngle = Math.atan2(other.direction.getY(), other.direction.getX());
        return PlaneAngleRadians.normalizeBetweenMinusPiAndPi((double)(otherAngle - thisAngle));
    }

    public Vector2D project(Vector2D point) {
        return this.toSpace(this.toSubspace(point));
    }

    public double offset(Vector2D point) {
        return this.originOffset - this.direction.signedArea(point);
    }

    public double offset(Line line) {
        if (this.isParallel(line)) {
            double dot = this.direction.dot(line.direction);
            return this.originOffset - Math.signum(dot) * line.originOffset;
        }
        return 0.0;
    }

    public boolean similarOrientation(Hyperplane<Vector2D> other) {
        Line otherLine = (Line)other;
        return this.direction.dot(otherLine.direction) >= 0.0;
    }

    public Vector2D pointAt(double abscissa, double offset) {
        double pointOffset = offset - this.originOffset;
        return Vector2D.of(LinearCombination.value((double)abscissa, (double)this.direction.getX(), (double)pointOffset, (double)this.direction.getY()), LinearCombination.value((double)abscissa, (double)this.direction.getY(), (double)(-pointOffset), (double)this.direction.getX()));
    }

    public boolean contains(Vector2D p) {
        return this.getPrecision().eqZero(this.offset(p));
    }

    public boolean contains(Line line) {
        return this.isParallel(line) && this.getPrecision().eqZero(this.offset(line));
    }

    public double distance(Vector2D p) {
        return Math.abs(this.offset(p));
    }

    public double distance(Line line) {
        return Math.abs(this.offset(line));
    }

    public boolean isParallel(Line line) {
        double area = this.direction.signedArea(line.direction);
        return this.getPrecision().eqZero(area);
    }

    public boolean eq(Line other, DoublePrecisionContext precision) {
        return this.getOrigin().eq(other.getOrigin(), precision) && precision.eq(this.getAngle(), other.getAngle());
    }

    public int hashCode() {
        int prime = 167;
        int result = 1;
        result = 167 * result + Objects.hashCode(this.direction);
        result = 167 * result + Double.hashCode(this.originOffset);
        result = 167 * result + Objects.hashCode(this.getPrecision());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Line)) {
            return false;
        }
        Line other = (Line)((Object)obj);
        return Objects.equals(this.direction, other.direction) && Double.compare(this.originOffset, other.originOffset) == 0 && Objects.equals(this.getPrecision(), other.getPrecision());
    }

    public String toString() {
        return MessageFormat.format(TO_STRING_FORMAT, ((Object)((Object)this)).getClass().getSimpleName(), this.getOrigin(), this.getDirection());
    }

    public static final class SubspaceTransform {
        private final Line line;
        private final AffineTransformMatrix1D transform;

        public SubspaceTransform(Line line, AffineTransformMatrix1D transform) {
            this.line = line;
            this.transform = transform;
        }

        public Line getLine() {
            return this.line;
        }

        public AffineTransformMatrix1D getTransform() {
            return this.transform;
        }
    }
}

