/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.AbstractConvexHyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.BoundarySource2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.path.InteriorAngleLinePathConnector;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;

public class ConvexArea
extends AbstractConvexHyperplaneBoundedRegion<Vector2D, LineConvexSubset>
implements BoundarySource2D {
    private static final String NON_CONVEX_PATH_ERROR = "Cannot construct convex polygon from non-convex path: ";
    private static final ConvexArea FULL = new ConvexArea(Collections.emptyList());

    protected ConvexArea(List<LineConvexSubset> boundaries) {
        super(boundaries);
    }

    public Stream<LineConvexSubset> boundaryStream() {
        return this.getBoundaries().stream();
    }

    public List<LinePath> getBoundaryPaths() {
        return InteriorAngleLinePathConnector.connectMaximized(this.getBoundaries());
    }

    public List<Vector2D> getVertices() {
        List<LinePath> paths = this.getBoundaryPaths();
        if (paths.size() == 1) {
            LinePath path = paths.get(0);
            List<Vector2D> vertices = path.getVertexSequence();
            if (path.isClosed()) {
                return vertices.subList(0, vertices.size() - 1);
            }
            return vertices;
        }
        return Collections.emptyList();
    }

    public ConvexArea transform(Transform<Vector2D> transform) {
        return (ConvexArea)this.transformInternal(transform, this, LineConvexSubset.class, ConvexArea::new);
    }

    public LineConvexSubset trim(HyperplaneConvexSubset<Vector2D> convexSubset) {
        return (LineConvexSubset)super.trim(convexSubset);
    }

    public double getSize() {
        if (this.isFull()) {
            return Double.POSITIVE_INFINITY;
        }
        double quadrilateralAreaSum = 0.0;
        for (LineConvexSubset boundary : this.getBoundaries()) {
            if (boundary.isInfinite()) {
                return Double.POSITIVE_INFINITY;
            }
            quadrilateralAreaSum += boundary.getStartPoint().signedArea(boundary.getEndPoint());
        }
        return 0.5 * quadrilateralAreaSum;
    }

    public Vector2D getCentroid() {
        List boundaries = this.getBoundaries();
        double quadrilateralAreaSum = 0.0;
        double scaledSumX = 0.0;
        double scaledSumY = 0.0;
        for (LineConvexSubset seg : boundaries) {
            if (seg.isInfinite()) {
                return null;
            }
            Vector2D startPoint = seg.getStartPoint();
            Vector2D endPoint = seg.getEndPoint();
            double signedArea = startPoint.signedArea(endPoint);
            quadrilateralAreaSum += signedArea;
            scaledSumX += signedArea * (startPoint.getX() + endPoint.getX());
            scaledSumY += signedArea * (startPoint.getY() + endPoint.getY());
        }
        if (quadrilateralAreaSum > 0.0) {
            return Vector2D.of(scaledSumX, scaledSumY).multiply(1.0 / (3.0 * quadrilateralAreaSum));
        }
        return null;
    }

    public Split<ConvexArea> split(Hyperplane<Vector2D> splitter) {
        return this.splitInternal(splitter, this, LineConvexSubset.class, ConvexArea::new);
    }

    @Override
    public RegionBSPTree2D toTree() {
        return RegionBSPTree2D.from(this.getBoundaries(), true);
    }

    public static ConvexArea full() {
        return FULL;
    }

    public static ConvexArea convexPolygonFromVertices(Collection<Vector2D> vertices, DoublePrecisionContext precision) {
        return ConvexArea.convexPolygonFromPath(LinePath.fromVertexLoop(vertices, precision));
    }

    public static ConvexArea convexPolygonFromPath(LinePath path) {
        if (!path.isClosed()) {
            throw new IllegalArgumentException("Cannot construct convex polygon from unclosed path: " + path);
        }
        List<LineConvexSubset> elements = path.getElements();
        if (elements.size() < 3) {
            throw new IllegalArgumentException("Cannot construct convex polygon from path with less than 3 elements: " + path);
        }
        LineConvexSubset startElement = elements.get(0);
        Vector2D startVertex = startElement.getStartPoint();
        DoublePrecisionContext precision = startElement.getPrecision();
        Vector2D prevVector = null;
        double totalSignedArea = 0.0;
        for (int i = 0; i < elements.size() - 1; ++i) {
            LineConvexSubset element = elements.get(i);
            Vector2D curVector = startVertex.vectorTo(element.getEndPoint());
            if (prevVector != null) {
                double signedArea = prevVector.signedArea(curVector);
                if (precision.lt(signedArea, 0.0)) {
                    throw new IllegalArgumentException(NON_CONVEX_PATH_ERROR + path);
                }
                totalSignedArea += signedArea;
            }
            prevVector = curVector;
        }
        if (precision.lte(totalSignedArea, 0.0)) {
            throw new IllegalArgumentException(NON_CONVEX_PATH_ERROR + path);
        }
        return new ConvexArea(elements);
    }

    public static ConvexArea fromBounds(Line ... bounds) {
        return ConvexArea.fromBounds(Arrays.asList(bounds));
    }

    public static ConvexArea fromBounds(Iterable<Line> bounds) {
        List subsets = new AbstractConvexHyperplaneBoundedRegion.ConvexRegionBoundaryBuilder(LineConvexSubset.class).build(bounds);
        return subsets.isEmpty() ? ConvexArea.full() : new ConvexArea(subsets);
    }
}

