/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.function.UnaryOperator;
import org.apache.commons.geometry.core.internal.DoubleFunction2N;
import org.apache.commons.geometry.euclidean.AbstractAffineTransformMatrix;
import org.apache.commons.geometry.euclidean.internal.Matrices;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.rotation.Rotation2D;
import org.apache.commons.numbers.arrays.LinearCombination;

public final class AffineTransformMatrix2D
extends AbstractAffineTransformMatrix<Vector2D, AffineTransformMatrix2D> {
    private static final int NUM_ELEMENTS = 6;
    private static final String MATRIX_START = "[ ";
    private static final String MATRIX_END = " ]";
    private static final String ELEMENT_SEPARATOR = ", ";
    private static final String ROW_SEPARATOR = "; ";
    private static final AffineTransformMatrix2D IDENTITY_INSTANCE = new AffineTransformMatrix2D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    private final double m00;
    private final double m01;
    private final double m02;
    private final double m10;
    private final double m11;
    private final double m12;

    private AffineTransformMatrix2D(double m00, double m01, double m02, double m10, double m11, double m12) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
    }

    public double[] toArray() {
        return new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
    }

    public Vector2D apply(Vector2D pt) {
        double x = pt.getX();
        double y = pt.getY();
        double resultX = LinearCombination.value((double)this.m00, (double)x, (double)this.m01, (double)y) + this.m02;
        double resultY = LinearCombination.value((double)this.m10, (double)x, (double)this.m11, (double)y) + this.m12;
        return Vector2D.of(resultX, resultY);
    }

    @Override
    public Vector2D applyVector(Vector2D vec) {
        return (Vector2D)this.applyVector(vec, Vector2D::of);
    }

    @Override
    public Vector2D.Unit applyDirection(Vector2D vec) {
        return (Vector2D.Unit)this.applyVector(vec, Vector2D.Unit::from);
    }

    @Override
    public double determinant() {
        return Matrices.determinant(this.m00, this.m01, this.m10, this.m11);
    }

    @Override
    public AffineTransformMatrix2D linear() {
        return new AffineTransformMatrix2D(this.m00, this.m01, 0.0, this.m10, this.m11, 0.0);
    }

    @Override
    public AffineTransformMatrix2D linearTranspose() {
        return new AffineTransformMatrix2D(this.m00, this.m10, 0.0, this.m01, this.m11, 0.0);
    }

    public AffineTransformMatrix2D translate(Vector2D translation) {
        return this.translate(translation.getX(), translation.getY());
    }

    public AffineTransformMatrix2D translate(double x, double y) {
        return new AffineTransformMatrix2D(this.m00, this.m01, this.m02 + x, this.m10, this.m11, this.m12 + y);
    }

    public AffineTransformMatrix2D scale(double factor) {
        return this.scale(factor, factor);
    }

    public AffineTransformMatrix2D scale(Vector2D scaleFactors) {
        return this.scale(scaleFactors.getX(), scaleFactors.getY());
    }

    public AffineTransformMatrix2D scale(double x, double y) {
        return new AffineTransformMatrix2D(this.m00 * x, this.m01 * x, this.m02 * x, this.m10 * y, this.m11 * y, this.m12 * y);
    }

    public AffineTransformMatrix2D rotate(double angle) {
        return this.rotate(Rotation2D.of(angle));
    }

    public AffineTransformMatrix2D rotate(Rotation2D rotation) {
        return AffineTransformMatrix2D.multiply(rotation.toMatrix(), this);
    }

    public AffineTransformMatrix2D rotate(Vector2D center, double angle) {
        return AffineTransformMatrix2D.multiply(AffineTransformMatrix2D.createRotation(center, angle), this);
    }

    public AffineTransformMatrix2D rotate(Vector2D center, Rotation2D rotation) {
        return this.rotate(center, rotation.getAngle());
    }

    public AffineTransformMatrix2D multiply(AffineTransformMatrix2D m) {
        return AffineTransformMatrix2D.multiply(this, m);
    }

    public AffineTransformMatrix2D premultiply(AffineTransformMatrix2D m) {
        return AffineTransformMatrix2D.multiply(m, this);
    }

    @Override
    public AffineTransformMatrix2D inverse() {
        double det = Matrices.checkDeterminantForInverse(this.determinant());
        Matrices.checkElementForInverse(this.m02);
        Matrices.checkElementForInverse(this.m12);
        double invDet = 1.0 / det;
        double c00 = invDet * this.m11;
        double c01 = -invDet * this.m10;
        double c10 = -invDet * this.m01;
        double c11 = invDet * this.m00;
        double c20 = invDet * Matrices.determinant(this.m01, this.m02, this.m11, this.m12);
        double c21 = -invDet * Matrices.determinant(this.m00, this.m02, this.m10, this.m12);
        return new AffineTransformMatrix2D(c00, c10, c20, c01, c11, c21);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + (Double.hashCode(this.m00) - Double.hashCode(this.m01) + Double.hashCode(this.m02));
        result = result * 31 + (Double.hashCode(this.m10) - Double.hashCode(this.m11) + Double.hashCode(this.m12));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffineTransformMatrix2D)) {
            return false;
        }
        AffineTransformMatrix2D other = (AffineTransformMatrix2D)obj;
        return Double.compare(this.m00, other.m00) == 0 && Double.compare(this.m01, other.m01) == 0 && Double.compare(this.m02, other.m02) == 0 && Double.compare(this.m10, other.m10) == 0 && Double.compare(this.m11, other.m11) == 0 && Double.compare(this.m12, other.m12) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MATRIX_START).append(this.m00).append(ELEMENT_SEPARATOR).append(this.m01).append(ELEMENT_SEPARATOR).append(this.m02).append(ROW_SEPARATOR).append(this.m10).append(ELEMENT_SEPARATOR).append(this.m11).append(ELEMENT_SEPARATOR).append(this.m12).append(MATRIX_END);
        return sb.toString();
    }

    private <T> T applyVector(Vector2D vec, DoubleFunction2N<T> factory) {
        double x = vec.getX();
        double y = vec.getY();
        double resultX = LinearCombination.value((double)this.m00, (double)x, (double)this.m01, (double)y);
        double resultY = LinearCombination.value((double)this.m10, (double)x, (double)this.m11, (double)y);
        return (T)factory.apply(resultX, resultY);
    }

    public static AffineTransformMatrix2D of(double ... arr) {
        if (arr.length != 6) {
            throw new IllegalArgumentException("Dimension mismatch: " + arr.length + " != " + 6);
        }
        return new AffineTransformMatrix2D(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
    }

    public static AffineTransformMatrix2D from(UnaryOperator<Vector2D> fn) {
        Vector2D v;
        Vector2D tPlusX = (Vector2D)fn.apply(Vector2D.Unit.PLUS_X);
        Vector2D tPlusY = (Vector2D)fn.apply(Vector2D.Unit.PLUS_Y);
        Vector2D tZero = (Vector2D)fn.apply(Vector2D.ZERO);
        Vector2D u = tPlusX.subtract(tZero);
        AffineTransformMatrix2D mat = AffineTransformMatrix2D.fromColumnVectors(u, v = tPlusY.subtract(tZero), tZero);
        double det = mat.determinant();
        if (!Vectors.isRealNonZero(det)) {
            throw new IllegalArgumentException("Transform function is invalid: matrix determinant is " + det);
        }
        return mat;
    }

    public static AffineTransformMatrix2D fromColumnVectors(Vector2D u, Vector2D v) {
        return AffineTransformMatrix2D.fromColumnVectors(u, v, Vector2D.ZERO);
    }

    public static AffineTransformMatrix2D fromColumnVectors(Vector2D u, Vector2D v, Vector2D t) {
        return new AffineTransformMatrix2D(u.getX(), v.getX(), t.getX(), u.getY(), v.getY(), t.getY());
    }

    public static AffineTransformMatrix2D identity() {
        return IDENTITY_INSTANCE;
    }

    public static AffineTransformMatrix2D createTranslation(Vector2D translation) {
        return AffineTransformMatrix2D.createTranslation(translation.getX(), translation.getY());
    }

    public static AffineTransformMatrix2D createTranslation(double x, double y) {
        return new AffineTransformMatrix2D(1.0, 0.0, x, 0.0, 1.0, y);
    }

    public static AffineTransformMatrix2D createScale(double factor) {
        return AffineTransformMatrix2D.createScale(factor, factor);
    }

    public static AffineTransformMatrix2D createScale(Vector2D factors) {
        return AffineTransformMatrix2D.createScale(factors.getX(), factors.getY());
    }

    public static AffineTransformMatrix2D createScale(double x, double y) {
        return new AffineTransformMatrix2D(x, 0.0, 0.0, 0.0, y, 0.0);
    }

    public static AffineTransformMatrix2D createRotation(double angle) {
        return Rotation2D.of(angle).toMatrix();
    }

    public static AffineTransformMatrix2D createRotation(Vector2D center, double angle) {
        double x = center.getX();
        double y = center.getY();
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        return new AffineTransformMatrix2D(cos, -sin, -x * cos + y * sin + x, sin, cos, -x * sin - y * cos + y);
    }

    public static AffineTransformMatrix2D createRotation(Vector2D center, Rotation2D rotation) {
        return AffineTransformMatrix2D.createRotation(center, rotation.getAngle());
    }

    private static AffineTransformMatrix2D multiply(AffineTransformMatrix2D a, AffineTransformMatrix2D b) {
        double c00 = LinearCombination.value((double)a.m00, (double)b.m00, (double)a.m01, (double)b.m10);
        double c01 = LinearCombination.value((double)a.m00, (double)b.m01, (double)a.m01, (double)b.m11);
        double c02 = LinearCombination.value((double)a.m00, (double)b.m02, (double)a.m01, (double)b.m12) + a.m02;
        double c10 = LinearCombination.value((double)a.m10, (double)b.m00, (double)a.m11, (double)b.m10);
        double c11 = LinearCombination.value((double)a.m10, (double)b.m01, (double)a.m11, (double)b.m11);
        double c12 = LinearCombination.value((double)a.m10, (double)b.m02, (double)a.m11, (double)b.m12) + a.m12;
        return new AffineTransformMatrix2D(c00, c01, c02, c10, c11, c12);
    }
}

