/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.mesh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;

public final class SimpleTriangleMesh
implements TriangleMesh {
    private final List<Vector3D> vertices;
    private final List<int[]> faces;
    private final Bounds3D bounds;
    private final DoublePrecisionContext precision;

    private SimpleTriangleMesh(List<Vector3D> vertices, List<int[]> faces, Bounds3D bounds, DoublePrecisionContext precision) {
        this.vertices = Collections.unmodifiableList(vertices);
        this.faces = Collections.unmodifiableList(faces);
        this.bounds = bounds;
        this.precision = precision;
    }

    @Override
    public Iterable<Vector3D> vertices() {
        return this.getVertices();
    }

    @Override
    public List<Vector3D> getVertices() {
        return this.vertices;
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public Iterable<TriangleMesh.Face> faces() {
        return () -> new FaceIterator(Function.identity());
    }

    @Override
    public List<TriangleMesh.Face> getFaces() {
        int count = this.getFaceCount();
        ArrayList<TriangleMesh.Face> faceList = new ArrayList<TriangleMesh.Face>(count);
        for (int i = 0; i < count; ++i) {
            faceList.add(this.getFace(i));
        }
        return faceList;
    }

    @Override
    public int getFaceCount() {
        return this.faces.size();
    }

    @Override
    public TriangleMesh.Face getFace(int index) {
        return new SimpleTriangleFace(index, this.faces.get(index));
    }

    @Override
    public Bounds3D getBounds() {
        return this.bounds;
    }

    public DoublePrecisionContext getPrecision() {
        return this.precision;
    }

    public Stream<PlaneConvexSubset> boundaryStream() {
        return this.createFaceStream(TriangleMesh.Face::getPolygon);
    }

    @Override
    public Stream<Triangle3D> triangleStream() {
        return this.createFaceStream(TriangleMesh.Face::getPolygon);
    }

    @Override
    public SimpleTriangleMesh transform(Transform<Vector3D> transform) {
        Bounds3D.Builder boundsBuilder = Bounds3D.builder();
        ArrayList<Vector3D> tVertices = new ArrayList<Vector3D>(this.vertices.size());
        for (Vector3D vertex : this.vertices) {
            Vector3D tVertex = (Vector3D)transform.apply((Object)vertex);
            boundsBuilder.add(tVertex);
            tVertices.add(tVertex);
        }
        Bounds3D tBounds = boundsBuilder.hasBounds() ? boundsBuilder.build() : null;
        return new SimpleTriangleMesh(tVertices, this.faces, tBounds, this.precision);
    }

    @Override
    public SimpleTriangleMesh toTriangleMesh(DoublePrecisionContext meshPrecision) {
        if (this.precision.equals(meshPrecision)) {
            return this;
        }
        return new SimpleTriangleMesh(this.vertices, this.faces, this.bounds, meshPrecision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[vertexCount= ").append(this.getVertexCount()).append(", faceCount= ").append(this.getFaceCount()).append(", bounds= ").append(this.getBounds()).append(']');
        return sb.toString();
    }

    private <T> Stream<T> createFaceStream(Function<TriangleMesh.Face, T> fn) {
        Iterable iterable = () -> new FaceIterator(fn);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static Builder builder(DoublePrecisionContext precision) {
        return new Builder(precision);
    }

    public static SimpleTriangleMesh from(Vector3D[] vertices, int[][] faces, DoublePrecisionContext precision) {
        return SimpleTriangleMesh.from(Arrays.asList(vertices), Arrays.asList(faces), precision);
    }

    public static SimpleTriangleMesh from(Collection<Vector3D> vertices, Collection<int[]> faces, DoublePrecisionContext precision) {
        Builder builder = SimpleTriangleMesh.builder(precision);
        return builder.addVertices(vertices).addFaces(faces).build();
    }

    public static SimpleTriangleMesh from(BoundarySource3D boundarySrc, DoublePrecisionContext precision) {
        Builder builder = SimpleTriangleMesh.builder(precision);
        try (Stream<Triangle3D> stream = boundarySrc.triangleStream();){
            stream.forEach(tri -> builder.addFaceUsingVertices(tri.getPoint1(), tri.getPoint2(), tri.getPoint3()));
        }
        return builder.build();
    }

    private static final class FuzzyVectorComparator
    implements Comparator<Vector3D> {
        private final DoublePrecisionContext precision;

        FuzzyVectorComparator(DoublePrecisionContext precision) {
            this.precision = precision;
        }

        @Override
        public int compare(Vector3D a, Vector3D b) {
            int result = this.precision.compare(a.getX(), b.getX());
            if (result == 0 && (result = this.precision.compare(a.getY(), b.getY())) == 0) {
                result = this.precision.compare(a.getZ(), b.getZ());
            }
            return result;
        }
    }

    public static final class Builder {
        private final ArrayList<Vector3D> vertices = new ArrayList();
        private Map<Vector3D, Integer> vertexIndexMap;
        private final ArrayList<int[]> faces = new ArrayList();
        private final Bounds3D.Builder boundsBuilder = Bounds3D.builder();
        private final DoublePrecisionContext precision;
        private boolean built = false;

        private Builder(DoublePrecisionContext precision) {
            Objects.requireNonNull(precision, "Precision context must not be null");
            this.precision = precision;
        }

        public int useVertex(Vector3D vertex) {
            int nextIdx = this.vertices.size();
            int actualIdx = this.addToVertexIndexMap(vertex, nextIdx, this.getVertexIndexMap());
            if (actualIdx == nextIdx) {
                this.addToVertexList(vertex);
            }
            return actualIdx;
        }

        public int addVertex(Vector3D vertex) {
            int idx = this.addToVertexList(vertex);
            if (this.vertexIndexMap != null) {
                this.addToVertexIndexMap(vertex, idx, this.vertexIndexMap);
            }
            return idx;
        }

        public Builder addVertices(Vector3D[] newVertices) {
            return this.addVertices(Arrays.asList(newVertices));
        }

        public Builder addVertices(Collection<Vector3D> newVertices) {
            int newSize = this.vertices.size() + newVertices.size();
            this.ensureVertexCapacity(newSize);
            for (Vector3D vertex : newVertices) {
                this.addVertex(vertex);
            }
            return this;
        }

        public Builder ensureVertexCapacity(int numVertices) {
            this.vertices.ensureCapacity(numVertices);
            return this;
        }

        public int getVertexCount() {
            return this.vertices.size();
        }

        public Builder addFace(int index1, int index2, int index3) {
            this.validateCanModify();
            int[] indices = new int[]{this.validateVertexIndex(index1), this.validateVertexIndex(index2), this.validateVertexIndex(index3)};
            this.faces.add(indices);
            return this;
        }

        public Builder addFaces(int[][] faceIndices) {
            return this.addFaces(Arrays.asList(faceIndices));
        }

        public Builder addFaces(Collection<int[]> faceIndices) {
            int newSize = this.faces.size() + faceIndices.size();
            this.ensureFaceCapacity(newSize);
            for (int[] face : faceIndices) {
                if (face.length != 3) {
                    throw new IllegalArgumentException("Face must contain 3 vertex indices; found " + face.length);
                }
                this.addFace(face[0], face[1], face[2]);
            }
            return this;
        }

        public Builder addFaceUsingVertices(Vector3D p1, Vector3D p2, Vector3D p3) {
            return this.addFace(this.useVertex(p1), this.useVertex(p2), this.useVertex(p3));
        }

        public Builder addFaceAndVertices(Vector3D p1, Vector3D p2, Vector3D p3) {
            return this.addFace(this.addVertex(p1), this.addVertex(p2), this.addVertex(p3));
        }

        public Builder ensureFaceCapacity(int numFaces) {
            this.faces.ensureCapacity(numFaces);
            return this;
        }

        public int getFaceCount() {
            return this.faces.size();
        }

        public SimpleTriangleMesh build() {
            this.built = true;
            Bounds3D bounds = this.boundsBuilder.hasBounds() ? this.boundsBuilder.build() : null;
            this.vertices.trimToSize();
            this.faces.trimToSize();
            return new SimpleTriangleMesh(this.vertices, this.faces, bounds, this.precision);
        }

        private Map<Vector3D, Integer> getVertexIndexMap() {
            if (this.vertexIndexMap == null) {
                this.vertexIndexMap = new TreeMap<Vector3D, Integer>(new FuzzyVectorComparator(this.precision));
                int size = this.vertices.size();
                for (int i = 0; i < size; ++i) {
                    this.addToVertexIndexMap(this.vertices.get(i), i, this.vertexIndexMap);
                }
            }
            return this.vertexIndexMap;
        }

        private int addToVertexIndexMap(Vector3D vertex, int targetIdx, Map<Vector3D, Integer> map) {
            this.validateCanModify();
            Integer actualIdx = map.putIfAbsent(vertex, targetIdx);
            return actualIdx != null ? actualIdx : targetIdx;
        }

        private int addToVertexList(Vector3D vertex) {
            this.validateCanModify();
            this.boundsBuilder.add(vertex);
            int idx = this.vertices.size();
            this.vertices.add(vertex);
            return idx;
        }

        private int validateVertexIndex(int idx) {
            if (idx < 0 || idx >= this.vertices.size()) {
                throw new IllegalArgumentException("Invalid vertex index: " + idx);
            }
            return idx;
        }

        private void validateCanModify() {
            if (this.built) {
                throw new IllegalStateException("Builder instance cannot be modified: mesh construction is complete");
            }
        }
    }

    private final class FaceIterator<T>
    implements Iterator<T> {
        private int index = 0;
        private final Function<TriangleMesh.Face, T> fn;

        FaceIterator(Function<TriangleMesh.Face, T> fn) {
            this.fn = fn;
        }

        @Override
        public boolean hasNext() {
            return this.index < SimpleTriangleMesh.this.faces.size();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                TriangleMesh.Face face = SimpleTriangleMesh.this.getFace(this.index++);
                return this.fn.apply(face);
            }
            throw new NoSuchElementException();
        }
    }

    private final class SimpleTriangleFace
    implements TriangleMesh.Face {
        private final int index;
        private final int[] vertexIndices;

        SimpleTriangleFace(int index, int[] vertexIndices) {
            this.index = index;
            this.vertexIndices = vertexIndices;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int[] getVertexIndices() {
            return (int[])this.vertexIndices.clone();
        }

        @Override
        public List<Vector3D> getVertices() {
            return Arrays.asList(this.getPoint1(), this.getPoint2(), this.getPoint3());
        }

        @Override
        public Vector3D getPoint1() {
            return (Vector3D)SimpleTriangleMesh.this.vertices.get(this.vertexIndices[0]);
        }

        @Override
        public Vector3D getPoint2() {
            return (Vector3D)SimpleTriangleMesh.this.vertices.get(this.vertexIndices[1]);
        }

        @Override
        public Vector3D getPoint3() {
            return (Vector3D)SimpleTriangleMesh.this.vertices.get(this.vertexIndices[2]);
        }

        @Override
        public boolean definesPolygon() {
            Vector3D p1 = this.getPoint1();
            Vector3D v1 = p1.vectorTo(this.getPoint2());
            Vector3D v2 = p1.vectorTo(this.getPoint3());
            return !SimpleTriangleMesh.this.precision.eqZero(v1.cross(v2).norm());
        }

        @Override
        public Triangle3D getPolygon() {
            return Planes.triangleFromVertices(this.getPoint1(), this.getPoint2(), this.getPoint3(), SimpleTriangleMesh.this.precision);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append("[index= ").append(this.getIndex()).append(", vertexIndices= ").append(Arrays.toString(this.getVertexIndices())).append(", vertices= ").append(this.getVertices()).append(']');
            return sb.toString();
        }
    }
}

