/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import java.text.MessageFormat;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.oned.Interval;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.LineSpanningSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.Ray3D;
import org.apache.commons.geometry.euclidean.threed.line.ReverseRay3D;
import org.apache.commons.geometry.euclidean.threed.line.Segment3D;

public final class Lines3D {
    private Lines3D() {
    }

    public static Line3D fromPoints(Vector3D p1, Vector3D p2, DoublePrecisionContext precision) {
        return Lines3D.fromPointAndDirection(p1, p1.vectorTo(p2), precision);
    }

    public static Line3D fromPointAndDirection(Vector3D pt, Vector3D dir, DoublePrecisionContext precision) {
        if (dir.isZero(precision)) {
            throw new IllegalArgumentException("Line direction cannot be zero");
        }
        Vector3D.Unit normDirection = dir.normalize();
        Vector3D origin = pt.reject(normDirection);
        return new Line3D(origin, normDirection, precision);
    }

    public static Ray3D rayFromPointAndDirection(Vector3D startPoint, Vector3D direction, DoublePrecisionContext precision) {
        Line3D line = Lines3D.fromPointAndDirection(startPoint, direction, precision);
        return new Ray3D(line, startPoint);
    }

    public static Ray3D rayFromPoint(Line3D line, Vector3D startPoint) {
        return Lines3D.rayFromLocation(line, line.abscissa(startPoint));
    }

    public static Ray3D rayFromLocation(Line3D line, double startLocation) {
        if (!Double.isFinite(startLocation)) {
            throw new IllegalArgumentException("Invalid ray start location: " + startLocation);
        }
        return new Ray3D(line, startLocation);
    }

    public static ReverseRay3D reverseRayFromPointAndDirection(Vector3D endPoint, Vector3D lineDirection, DoublePrecisionContext precision) {
        Line3D line = Lines3D.fromPointAndDirection(endPoint, lineDirection, precision);
        return new ReverseRay3D(line, endPoint);
    }

    public static ReverseRay3D reverseRayFromPoint(Line3D line, Vector3D endPoint) {
        return Lines3D.reverseRayFromLocation(line, line.abscissa(endPoint));
    }

    public static ReverseRay3D reverseRayFromLocation(Line3D line, double endLocation) {
        if (!Double.isFinite(endLocation)) {
            throw new IllegalArgumentException("Invalid reverse ray end location: " + endLocation);
        }
        return new ReverseRay3D(line, endLocation);
    }

    public static Segment3D segmentFromPoints(Vector3D startPoint, Vector3D endPoint, DoublePrecisionContext precision) {
        Line3D line = Lines3D.fromPoints(startPoint, endPoint, precision);
        return new Segment3D(line, startPoint, endPoint);
    }

    public static Segment3D segmentFromPoints(Line3D line, Vector3D a, Vector3D b) {
        return Lines3D.segmentFromLocations(line, line.abscissa(a), line.abscissa(b));
    }

    public static Segment3D segmentFromLocations(Line3D line, double a, double b) {
        if (Double.isFinite(a) && Double.isFinite(b)) {
            double min = Math.min(a, b);
            double max = Math.max(a, b);
            return new Segment3D(line, min, max);
        }
        throw new IllegalArgumentException(MessageFormat.format("Invalid line segment locations: {0}, {1}", Double.toString(a), Double.toString(b)));
    }

    public static LineConvexSubset3D span(Line3D line) {
        return new LineSpanningSubset3D(line);
    }

    public static LineConvexSubset3D subsetFromInterval(Line3D line, Interval interval) {
        return Lines3D.subsetFromInterval(line, interval.getMin(), interval.getMax());
    }

    public static LineConvexSubset3D subsetFromInterval(Line3D line, double a, double b) {
        double min = Math.min(a, b);
        double max = Math.max(a, b);
        boolean hasMin = Double.isFinite(min);
        boolean hasMax = Double.isFinite(max);
        if (hasMin) {
            if (hasMax) {
                return new Segment3D(line, min, max);
            }
            return new Ray3D(line, min);
        }
        if (hasMax) {
            return new ReverseRay3D(line, max);
        }
        if (Double.isInfinite(min) && Double.isInfinite(max) && Double.compare(min, max) < 0) {
            return new LineSpanningSubset3D(line);
        }
        throw new IllegalArgumentException(MessageFormat.format("Invalid line convex subset interval: {0}, {1}", Double.toString(a), Double.toString(b)));
    }

    public static LineConvexSubset3D subsetFromInterval(Line3D line, Vector1D a, Vector1D b) {
        return Lines3D.subsetFromInterval(line, a.getX(), b.getX());
    }
}

