/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.AbstractLinecastPoint;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;

public class LinecastPoint3D
extends AbstractLinecastPoint<Vector3D, Vector3D.Unit, Line3D> {
    public static final Comparator<LinecastPoint3D> ABSCISSA_ORDER = (a, b) -> {
        int cmp = Double.compare(a.getAbscissa(), b.getAbscissa());
        if (cmp == 0) {
            cmp = Vector3D.COORDINATE_ASCENDING_ORDER.compare((Vector3D)a.getNormal(), (Vector3D)b.getNormal());
        }
        return cmp;
    };

    public LinecastPoint3D(Vector3D point, Vector3D normal, Line3D line) {
        super(point, normal.normalize(), line);
    }

    public boolean eq(LinecastPoint3D other, DoublePrecisionContext precision) {
        return ((Line3D)this.getLine()).eq((Line3D)other.getLine(), precision) && ((Vector3D)this.getPoint()).eq((Vector3D)other.getPoint(), precision) && ((Vector3D.Unit)this.getNormal()).eq((Vector3D)other.getNormal(), precision);
    }

    public static void sortAndFilter(List<LinecastPoint3D> pts) {
        pts.sort(ABSCISSA_ORDER);
        double currentAbscissa = Double.POSITIVE_INFINITY;
        ArrayList<LinecastPoint3D> abscissaList = new ArrayList<LinecastPoint3D>();
        ListIterator<LinecastPoint3D> it = pts.listIterator();
        while (it.hasNext()) {
            LinecastPoint3D pt = it.next();
            if (!((Line3D)pt.getLine()).getPrecision().eq(currentAbscissa, pt.getAbscissa())) {
                currentAbscissa = pt.getAbscissa();
                abscissaList.clear();
                abscissaList.add(pt);
                continue;
            }
            if (LinecastPoint3D.containsEq(pt, abscissaList)) {
                it.remove();
                continue;
            }
            abscissaList.add(pt);
        }
    }

    private static boolean containsEq(LinecastPoint3D pt, List<LinecastPoint3D> list) {
        DoublePrecisionContext precision = ((Line3D)pt.getLine()).getPrecision();
        for (LinecastPoint3D listPt : list) {
            if (!listPt.eq(pt, precision)) continue;
            return true;
        }
        return false;
    }
}

