/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import java.text.MessageFormat;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;

final class LineSpanningSubset3D
extends LineConvexSubset3D {
    LineSpanningSubset3D(Line3D line) {
        super(line);
    }

    @Override
    public boolean isInfinite() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public double getSize() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Vector3D getStartPoint() {
        return null;
    }

    @Override
    public double getSubspaceStart() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Vector3D getEndPoint() {
        return null;
    }

    @Override
    public double getSubspaceEnd() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Vector3D getCentroid() {
        return null;
    }

    @Override
    public Bounds3D getBounds() {
        return null;
    }

    @Override
    public LineSpanningSubset3D transform(Transform<Vector3D> transform) {
        return new LineSpanningSubset3D(this.getLine().transform(transform));
    }

    public String toString() {
        Line3D line = this.getLine();
        return MessageFormat.format("{0}[origin= {1}, direction= {2}]", this.getClass().getSimpleName(), line.getOrigin(), line.getDirection());
    }

    @Override
    boolean containsAbscissa(double abscissa) {
        return true;
    }
}

