/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import java.text.MessageFormat;
import java.util.Objects;
import org.apache.commons.geometry.core.Embedding;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.oned.AffineTransformMatrix1D;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.Lines3D;
import org.apache.commons.geometry.euclidean.threed.line.Ray3D;
import org.apache.commons.geometry.euclidean.threed.line.ReverseRay3D;
import org.apache.commons.geometry.euclidean.threed.line.Segment3D;

public final class Line3D
implements Embedding<Vector3D, Vector1D> {
    static final String TO_STRING_FORMAT = "{0}[origin= {1}, direction= {2}]";
    private final Vector3D origin;
    private final Vector3D direction;
    private final DoublePrecisionContext precision;

    Line3D(Vector3D origin, Vector3D direction, DoublePrecisionContext precision) {
        this.origin = origin;
        this.direction = direction;
        this.precision = precision;
    }

    public Vector3D getOrigin() {
        return this.origin;
    }

    public Vector3D getDirection() {
        return this.direction;
    }

    public DoublePrecisionContext getPrecision() {
        return this.precision;
    }

    public Line3D reverse() {
        return new Line3D(this.origin, this.direction.negate(), this.precision);
    }

    public Line3D transform(Transform<Vector3D> transform) {
        Vector3D p1 = (Vector3D)transform.apply((Object)this.origin);
        Vector3D p2 = (Vector3D)transform.apply((Object)this.origin.add(this.direction));
        return Lines3D.fromPoints(p1, p2, this.precision);
    }

    public SubspaceTransform subspaceTransform(Transform<Vector3D> transform) {
        Vector3D p1 = (Vector3D)transform.apply((Object)this.origin);
        Vector3D p2 = (Vector3D)transform.apply((Object)this.origin.add(this.direction));
        Line3D tLine = Lines3D.fromPoints(p1, p2, this.precision);
        Vector1D tSubspaceOrigin = tLine.toSubspace(p1);
        Vector1D tSubspaceDirection = tSubspaceOrigin.vectorTo(tLine.toSubspace(p2));
        double translation = tSubspaceOrigin.getX();
        double scale = tSubspaceDirection.getX();
        AffineTransformMatrix1D subspaceTransform = AffineTransformMatrix1D.of(scale, translation);
        return new SubspaceTransform(tLine, subspaceTransform);
    }

    public double abscissa(Vector3D pt) {
        return pt.subtract(this.origin).dot(this.direction);
    }

    public Vector3D pointAt(double abscissa) {
        return Vector3D.linearCombination(1.0, this.origin, abscissa, this.direction);
    }

    public Vector1D toSubspace(Vector3D pt) {
        return Vector1D.of(this.abscissa(pt));
    }

    public Vector3D toSpace(Vector1D pt) {
        return this.toSpace(pt.getX());
    }

    public Vector3D toSpace(double abscissa) {
        return this.pointAt(abscissa);
    }

    public boolean isSimilarTo(Line3D line) {
        double angle = this.direction.angle(line.direction);
        return (this.precision.eqZero(angle) || this.precision.eq(Math.abs(angle), Math.PI)) && this.contains(line.origin);
    }

    public boolean contains(Vector3D pt) {
        return this.precision.eqZero(this.distance(pt));
    }

    public double distance(Vector3D pt) {
        Vector3D delta = pt.subtract(this.origin);
        Vector3D orthogonal = delta.reject(this.direction);
        return orthogonal.norm();
    }

    public double distance(Line3D line) {
        Vector3D normal = this.direction.cross(line.direction);
        double norm = normal.norm();
        if (this.precision.eqZero(norm)) {
            return this.distance(line.origin);
        }
        double offset = line.origin.subtract(this.origin).dot(normal) / norm;
        return Math.abs(offset);
    }

    public Vector3D closest(Line3D line) {
        double cos = this.direction.dot(line.direction);
        double n = 1.0 - cos * cos;
        if (this.precision.eqZero(n)) {
            return this.origin;
        }
        Vector3D delta = line.origin.subtract(this.origin);
        double a = delta.dot(this.direction);
        double b = delta.dot(line.direction);
        return Vector3D.linearCombination(1.0, this.origin, (a - b * cos) / n, this.direction);
    }

    public Vector3D intersection(Line3D line) {
        Vector3D closestPt = this.closest(line);
        return line.contains(closestPt) ? closestPt : null;
    }

    public LineConvexSubset3D span() {
        return Lines3D.span(this);
    }

    public Segment3D segment(double a, double b) {
        return Lines3D.segmentFromLocations(this, a, b);
    }

    public Segment3D segment(Vector3D a, Vector3D b) {
        return Lines3D.segmentFromPoints(this, a, b);
    }

    public ReverseRay3D reverseRayTo(Vector3D endPoint) {
        return Lines3D.reverseRayFromPoint(this, endPoint);
    }

    public ReverseRay3D reverseRayTo(double endLocation) {
        return Lines3D.reverseRayFromLocation(this, endLocation);
    }

    public Ray3D rayFrom(Vector3D startPoint) {
        return Lines3D.rayFromPoint(this, startPoint);
    }

    public Ray3D rayFrom(double startLocation) {
        return Lines3D.rayFromLocation(this, startLocation);
    }

    public boolean eq(Line3D other, DoublePrecisionContext ctx) {
        return this.getOrigin().eq(other.getOrigin(), ctx) && this.getDirection().eq(other.getDirection(), ctx);
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.direction, this.precision);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Line3D)) {
            return false;
        }
        Line3D other = (Line3D)obj;
        return this.origin.equals(other.origin) && this.direction.equals(other.direction) && this.precision.equals(other.precision);
    }

    public String toString() {
        return MessageFormat.format(TO_STRING_FORMAT, this.getClass().getSimpleName(), this.getOrigin(), this.getDirection());
    }

    public static final class SubspaceTransform {
        private final Line3D line;
        private final AffineTransformMatrix1D transform;

        public SubspaceTransform(Line3D line, AffineTransformMatrix1D transform) {
            this.line = line;
            this.transform = transform;
        }

        public Line3D getLine() {
            return this.line;
        }

        public AffineTransformMatrix1D getTransform() {
            return this.transform;
        }
    }
}

