/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.UnaryOperator;
import org.apache.commons.geometry.core.internal.DoubleFunction3N;
import org.apache.commons.geometry.core.internal.SimpleTupleFormat;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.MultiDimensionalEuclideanVector;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.numbers.arrays.LinearCombination;

public class Vector3D
extends MultiDimensionalEuclideanVector<Vector3D> {
    public static final Vector3D ZERO = new Vector3D(0.0, 0.0, 0.0);
    public static final Vector3D NaN = new Vector3D(Double.NaN, Double.NaN, Double.NaN);
    public static final Vector3D POSITIVE_INFINITY = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Vector3D NEGATIVE_INFINITY = new Vector3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    public static final Comparator<Vector3D> COORDINATE_ASCENDING_ORDER = (a, b) -> {
        int cmp = 0;
        if (a != null && b != null) {
            cmp = Double.compare(a.getX(), b.getX());
            if (cmp == 0 && (cmp = Double.compare(a.getY(), b.getY())) == 0) {
                cmp = Double.compare(a.getZ(), b.getZ());
            }
        } else if (a != null) {
            cmp = -1;
        } else if (b != null) {
            cmp = 1;
        }
        return cmp;
    };
    private final double x;
    private final double y;
    private final double z;

    private Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public int getDimension() {
        return 3;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x) || Double.isInfinite(this.y) || Double.isInfinite(this.z));
    }

    public boolean isFinite() {
        return Double.isFinite(this.x) && Double.isFinite(this.y) && Double.isFinite(this.z);
    }

    public Vector3D getZero() {
        return ZERO;
    }

    @Override
    public Vector3D vectorTo(Vector3D v) {
        return v.subtract(this);
    }

    @Override
    public Unit directionTo(Vector3D v) {
        return this.vectorTo(v).normalize();
    }

    @Override
    public Vector3D lerp(Vector3D p, double t) {
        return Vector3D.linearCombination(1.0 - t, this, t, p);
    }

    public double norm() {
        return Vectors.norm(this.x, this.y, this.z);
    }

    public double normSq() {
        return Vectors.normSq(this.x, this.y, this.z);
    }

    public Vector3D withNorm(double magnitude) {
        double m = magnitude / this.getCheckedNorm();
        return new Vector3D(m * this.x, m * this.y, m * this.z);
    }

    public Vector3D add(Vector3D v) {
        return new Vector3D(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3D add(double factor, Vector3D v) {
        return new Vector3D(this.x + factor * v.x, this.y + factor * v.y, this.z + factor * v.z);
    }

    public Vector3D subtract(Vector3D v) {
        return new Vector3D(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3D subtract(double factor, Vector3D v) {
        return new Vector3D(this.x - factor * v.x, this.y - factor * v.y, this.z - factor * v.z);
    }

    public Vector3D negate() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Unit normalize() {
        return Unit.from(this.x, this.y, this.z);
    }

    public Vector3D multiply(double a) {
        return new Vector3D(a * this.x, a * this.y, a * this.z);
    }

    public double distance(Vector3D v) {
        return Vectors.norm(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public double distanceSq(Vector3D v) {
        return Vectors.normSq(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public double dot(Vector3D v) {
        return LinearCombination.value((double)this.x, (double)v.x, (double)this.y, (double)v.y, (double)this.z, (double)v.z);
    }

    public double angle(Vector3D v) {
        double threshold;
        double normProduct = this.getCheckedNorm() * v.getCheckedNorm();
        double dot = this.dot(v);
        if (dot < -(threshold = normProduct * 0.99) || dot > threshold) {
            Vector3D cross = this.cross(v);
            if (dot >= 0.0) {
                return Math.asin(cross.norm() / normProduct);
            }
            return Math.PI - Math.asin(cross.norm() / normProduct);
        }
        return Math.acos(dot / normProduct);
    }

    @Override
    public Vector3D project(Vector3D base) {
        return this.getComponent(base, false, Vector3D::new);
    }

    @Override
    public Vector3D reject(Vector3D base) {
        return this.getComponent(base, true, Vector3D::new);
    }

    @Override
    public Unit orthogonal() {
        double threshold = 0.6 * this.getCheckedNorm();
        if (Math.abs(this.x) <= threshold) {
            double inverse = 1.0 / Vectors.norm(this.y, this.z);
            return new Unit(0.0, inverse * this.z, -inverse * this.y);
        }
        if (Math.abs(this.y) <= threshold) {
            double inverse = 1.0 / Vectors.norm(this.x, this.z);
            return new Unit(-inverse * this.z, 0.0, inverse * this.x);
        }
        double inverse = 1.0 / Vectors.norm(this.x, this.y);
        return new Unit(inverse * this.y, -inverse * this.x, 0.0);
    }

    @Override
    public Unit orthogonal(Vector3D dir) {
        return (Unit)dir.getComponent(this, true, Unit::from);
    }

    public Vector3D cross(Vector3D v) {
        return new Vector3D(LinearCombination.value((double)this.y, (double)v.z, (double)(-this.z), (double)v.y), LinearCombination.value((double)this.z, (double)v.x, (double)(-this.x), (double)v.z), LinearCombination.value((double)this.x, (double)v.y, (double)(-this.y), (double)v.x));
    }

    public Vector3D transform(UnaryOperator<Vector3D> fn) {
        return (Vector3D)fn.apply(this);
    }

    @Override
    public boolean eq(Vector3D vec, DoublePrecisionContext precision) {
        return precision.eq(this.x, vec.x) && precision.eq(this.y, vec.y) && precision.eq(this.z, vec.z);
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 642;
        }
        return 643 * (164 * Double.hashCode(this.x) + 3 * Double.hashCode(this.y) + Double.hashCode(this.z));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Vector3D) {
            Vector3D rhs = (Vector3D)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return Double.compare(this.x, rhs.x) == 0 && Double.compare(this.y, rhs.y) == 0 && Double.compare(this.z, rhs.z) == 0;
        }
        return false;
    }

    public String toString() {
        return SimpleTupleFormat.getDefault().format(this.x, this.y, this.z);
    }

    private <V extends Vector3D> V getComponent(Vector3D base, boolean reject, DoubleFunction3N<V> factory) {
        double aDotB = this.dot(base);
        double baseMagSq = Vectors.checkedNorm(base.normSq());
        double scale = aDotB / baseMagSq;
        double projX = scale * base.x;
        double projY = scale * base.y;
        double projZ = scale * base.z;
        if (reject) {
            return (V)((Vector3D)factory.apply(this.x - projX, this.y - projY, this.z - projZ));
        }
        return (V)((Vector3D)factory.apply(projX, projY, projZ));
    }

    public static Vector3D of(double x, double y, double z) {
        return new Vector3D(x, y, z);
    }

    public static Vector3D of(double[] v) {
        if (v.length != 3) {
            throw new IllegalArgumentException("Dimension mismatch: " + v.length + " != 3");
        }
        return new Vector3D(v[0], v[1], v[2]);
    }

    public static Vector3D parse(String str) {
        return (Vector3D)SimpleTupleFormat.getDefault().parse(str, Vector3D::new);
    }

    public static Vector3D max(Vector3D first, Vector3D ... more) {
        return Vector3D.computeMax(first, Arrays.asList(more).iterator());
    }

    public static Vector3D max(Iterable<Vector3D> vecs) {
        Iterator<Vector3D> it = vecs.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Cannot compute vector max: no vectors given");
        }
        return Vector3D.computeMax(it.next(), it);
    }

    private static Vector3D computeMax(Vector3D first, Iterator<Vector3D> more) {
        double x = first.getX();
        double y = first.getY();
        double z = first.getZ();
        while (more.hasNext()) {
            Vector3D vec = more.next();
            x = Math.max(x, vec.getX());
            y = Math.max(y, vec.getY());
            z = Math.max(z, vec.getZ());
        }
        return Vector3D.of(x, y, z);
    }

    public static Vector3D min(Vector3D first, Vector3D ... more) {
        return Vector3D.computeMin(first, Arrays.asList(more).iterator());
    }

    public static Vector3D min(Iterable<Vector3D> vecs) {
        Iterator<Vector3D> it = vecs.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Cannot compute vector min: no vectors given");
        }
        return Vector3D.computeMin(it.next(), it);
    }

    private static Vector3D computeMin(Vector3D first, Iterator<Vector3D> more) {
        double x = first.getX();
        double y = first.getY();
        double z = first.getZ();
        while (more.hasNext()) {
            Vector3D vec = more.next();
            x = Math.min(x, vec.getX());
            y = Math.min(y, vec.getY());
            z = Math.min(z, vec.getZ());
        }
        return Vector3D.of(x, y, z);
    }

    public static Vector3D centroid(Vector3D first, Vector3D ... more) {
        return Vector3D.computeCentroid(first, Arrays.asList(more).iterator());
    }

    public static Vector3D centroid(Iterable<Vector3D> pts) {
        Iterator<Vector3D> it = pts.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Cannot compute centroid: no points given");
        }
        return Vector3D.computeCentroid(it.next(), it);
    }

    private static Vector3D computeCentroid(Vector3D first, Iterator<Vector3D> more) {
        double x = first.getX();
        double y = first.getY();
        double z = first.getZ();
        int count = 1;
        while (more.hasNext()) {
            Vector3D pt = more.next();
            x += pt.getX();
            y += pt.getY();
            z += pt.getZ();
            ++count;
        }
        double invCount = 1.0 / (double)count;
        return new Vector3D(invCount * x, invCount * y, invCount * z);
    }

    public static Vector3D linearCombination(double a, Vector3D c) {
        return c.multiply(a);
    }

    public static Vector3D linearCombination(double a1, Vector3D v1, double a2, Vector3D v2) {
        return new Vector3D(LinearCombination.value((double)a1, (double)v1.x, (double)a2, (double)v2.x), LinearCombination.value((double)a1, (double)v1.y, (double)a2, (double)v2.y), LinearCombination.value((double)a1, (double)v1.z, (double)a2, (double)v2.z));
    }

    public static Vector3D linearCombination(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3) {
        return new Vector3D(LinearCombination.value((double)a1, (double)v1.x, (double)a2, (double)v2.x, (double)a3, (double)v3.x), LinearCombination.value((double)a1, (double)v1.y, (double)a2, (double)v2.y, (double)a3, (double)v3.y), LinearCombination.value((double)a1, (double)v1.z, (double)a2, (double)v2.z, (double)a3, (double)v3.z));
    }

    public static Vector3D linearCombination(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double a4, Vector3D v4) {
        return new Vector3D(LinearCombination.value((double)a1, (double)v1.x, (double)a2, (double)v2.x, (double)a3, (double)v3.x, (double)a4, (double)v4.x), LinearCombination.value((double)a1, (double)v1.y, (double)a2, (double)v2.y, (double)a3, (double)v3.y, (double)a4, (double)v4.y), LinearCombination.value((double)a1, (double)v1.z, (double)a2, (double)v2.z, (double)a3, (double)v3.z, (double)a4, (double)v4.z));
    }

    public static final class Unit
    extends Vector3D {
        public static final Unit PLUS_X = new Unit(1.0, 0.0, 0.0);
        public static final Unit MINUS_X = new Unit(-1.0, 0.0, 0.0);
        public static final Unit PLUS_Y = new Unit(0.0, 1.0, 0.0);
        public static final Unit MINUS_Y = new Unit(0.0, -1.0, 0.0);
        public static final Unit PLUS_Z = new Unit(0.0, 0.0, 1.0);
        public static final Unit MINUS_Z = new Unit(0.0, 0.0, -1.0);

        private Unit(double x, double y, double z) {
            super(x, y, z);
        }

        public static Unit from(double x, double y, double z) {
            double invNorm = 1.0 / Vectors.checkedNorm(Vectors.norm(x, y, z));
            return new Unit(x * invNorm, y * invNorm, z * invNorm);
        }

        public static Unit from(Vector3D v) {
            return v instanceof Unit ? (Unit)v : Unit.from(v.getX(), v.getY(), v.getZ());
        }

        @Override
        public double norm() {
            return 1.0;
        }

        @Override
        public double normSq() {
            return 1.0;
        }

        @Override
        public Unit normalize() {
            return this;
        }

        @Override
        public Vector3D withNorm(double mag) {
            return this.multiply(mag);
        }

        @Override
        public Unit negate() {
            return new Unit(-this.getX(), -this.getY(), -this.getZ());
        }
    }
}

