/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.AbstractBounds;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.shape.Parallelepiped;

public final class Bounds3D
extends AbstractBounds<Vector3D, Bounds3D> {
    private Bounds3D(Vector3D min, Vector3D max) {
        super(min, max);
    }

    @Override
    public boolean hasSize(DoublePrecisionContext precision) {
        Vector3D diag = (Vector3D)this.getDiagonal();
        return !precision.eqZero(diag.getX()) && !precision.eqZero(diag.getY()) && !precision.eqZero(diag.getZ());
    }

    @Override
    public boolean contains(Vector3D pt) {
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        Vector3D min = (Vector3D)this.getMin();
        Vector3D max = (Vector3D)this.getMax();
        return x >= min.getX() && x <= max.getX() && y >= min.getY() && y <= max.getY() && z >= min.getZ() && z <= max.getZ();
    }

    @Override
    public boolean contains(Vector3D pt, DoublePrecisionContext precision) {
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        Vector3D min = (Vector3D)this.getMin();
        Vector3D max = (Vector3D)this.getMax();
        return precision.gte(x, min.getX()) && precision.lte(x, max.getX()) && precision.gte(y, min.getY()) && precision.lte(y, max.getY()) && precision.gte(z, min.getZ()) && precision.lte(z, max.getZ());
    }

    @Override
    public boolean intersects(Bounds3D other) {
        Vector3D aMin = (Vector3D)this.getMin();
        Vector3D aMax = (Vector3D)this.getMax();
        Vector3D bMin = (Vector3D)other.getMin();
        Vector3D bMax = (Vector3D)other.getMax();
        return aMin.getX() <= bMax.getX() && aMax.getX() >= bMin.getX() && aMin.getY() <= bMax.getY() && aMax.getY() >= bMin.getY() && aMin.getZ() <= bMax.getZ() && aMax.getZ() >= bMin.getZ();
    }

    @Override
    public Bounds3D intersection(Bounds3D other) {
        if (this.intersects(other)) {
            Vector3D aMin = (Vector3D)this.getMin();
            Vector3D aMax = (Vector3D)this.getMax();
            Vector3D bMin = (Vector3D)other.getMin();
            Vector3D bMax = (Vector3D)other.getMax();
            double minX = Math.max(aMin.getX(), bMin.getX());
            double minY = Math.max(aMin.getY(), bMin.getY());
            double minZ = Math.max(aMin.getZ(), bMin.getZ());
            double maxX = Math.min(aMax.getX(), bMax.getX());
            double maxY = Math.min(aMax.getY(), bMax.getY());
            double maxZ = Math.min(aMax.getZ(), bMax.getZ());
            return new Bounds3D(Vector3D.of(minX, minY, minZ), Vector3D.of(maxX, maxY, maxZ));
        }
        return null;
    }

    public Parallelepiped toRegion(DoublePrecisionContext precision) {
        return Parallelepiped.axisAligned((Vector3D)this.getMin(), (Vector3D)this.getMax(), precision);
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Bounds3D)) {
            return false;
        }
        Bounds3D other = (Bounds3D)obj;
        return ((Vector3D)this.getMin()).equals(other.getMin()) && ((Vector3D)this.getMax()).equals(other.getMax());
    }

    public static Bounds3D from(Vector3D first, Vector3D ... more) {
        Builder builder = Bounds3D.builder();
        builder.add(first);
        builder.addAll(Arrays.asList(more));
        return builder.build();
    }

    public static Bounds3D from(Iterable<Vector3D> points) {
        Builder builder = Bounds3D.builder();
        builder.addAll(points);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private double minX = Double.POSITIVE_INFINITY;
        private double minY = Double.POSITIVE_INFINITY;
        private double minZ = Double.POSITIVE_INFINITY;
        private double maxX = Double.NEGATIVE_INFINITY;
        private double maxY = Double.NEGATIVE_INFINITY;
        private double maxZ = Double.NEGATIVE_INFINITY;

        private Builder() {
        }

        public Builder add(Vector3D pt) {
            double x = pt.getX();
            double y = pt.getY();
            double z = pt.getZ();
            this.minX = Math.min(x, this.minX);
            this.minY = Math.min(y, this.minY);
            this.minZ = Math.min(z, this.minZ);
            this.maxX = Math.max(x, this.maxX);
            this.maxY = Math.max(y, this.maxY);
            this.maxZ = Math.max(z, this.maxZ);
            return this;
        }

        public Builder addAll(Iterable<Vector3D> pts) {
            for (Vector3D pt : pts) {
                this.add(pt);
            }
            return this;
        }

        public Builder add(Bounds3D bounds) {
            this.add((Vector3D)bounds.getMin());
            this.add((Vector3D)bounds.getMax());
            return this;
        }

        public boolean hasBounds() {
            return Double.isFinite(this.minX) && Double.isFinite(this.minY) && Double.isFinite(this.minZ) && Double.isFinite(this.maxX) && Double.isFinite(this.maxY) && Double.isFinite(this.maxZ);
        }

        public Bounds3D build() {
            Vector3D min = Vector3D.of(this.minX, this.minY, this.minZ);
            Vector3D max = Vector3D.of(this.maxX, this.maxY, this.maxZ);
            if (!this.hasBounds()) {
                if (Double.isInfinite(this.minX) && this.minX > 0.0 && Double.isInfinite(this.maxX) && this.maxX < 0.0) {
                    throw new IllegalStateException("Cannot construct bounds: no points given");
                }
                throw new IllegalStateException("Invalid bounds: min= " + min + ", max= " + max);
            }
            return new Bounds3D(min, max);
        }
    }
}

