/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.oned;

import java.util.Comparator;
import java.util.function.UnaryOperator;
import org.apache.commons.geometry.core.internal.SimpleTupleFormat;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.EuclideanVector;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.numbers.arrays.LinearCombination;

public class Vector1D
extends EuclideanVector<Vector1D> {
    public static final Vector1D ZERO = new Vector1D(0.0);
    public static final Vector1D NaN = new Vector1D(Double.NaN);
    public static final Vector1D POSITIVE_INFINITY = new Vector1D(Double.POSITIVE_INFINITY);
    public static final Vector1D NEGATIVE_INFINITY = new Vector1D(Double.NEGATIVE_INFINITY);
    public static final Comparator<Vector1D> COORDINATE_ASCENDING_ORDER = (a, b) -> {
        int cmp = 0;
        if (a != null && b != null) {
            cmp = Double.compare(a.getX(), b.getX());
        } else if (a != null) {
            cmp = -1;
        } else if (b != null) {
            cmp = 1;
        }
        return cmp;
    };
    private final double x;

    private Vector1D(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public int getDimension() {
        return 1;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x);
    }

    public boolean isInfinite() {
        return !this.isNaN() && Double.isInfinite(this.x);
    }

    public boolean isFinite() {
        return Double.isFinite(this.x);
    }

    @Override
    public Vector1D vectorTo(Vector1D v) {
        return v.subtract(this);
    }

    @Override
    public Unit directionTo(Vector1D v) {
        return this.vectorTo(v).normalize();
    }

    @Override
    public Vector1D lerp(Vector1D p, double t) {
        return Vector1D.linearCombination(1.0 - t, this, t, p);
    }

    public Vector1D getZero() {
        return ZERO;
    }

    public double norm() {
        return Vectors.norm(this.x);
    }

    public double normSq() {
        return Vectors.normSq(this.x);
    }

    public Vector1D withNorm(double magnitude) {
        this.getCheckedNorm();
        return this.x > 0.0 ? new Vector1D(magnitude) : new Vector1D(-magnitude);
    }

    public Vector1D add(Vector1D v) {
        return new Vector1D(this.x + v.x);
    }

    public Vector1D add(double factor, Vector1D v) {
        return new Vector1D(this.x + factor * v.x);
    }

    public Vector1D subtract(Vector1D v) {
        return new Vector1D(this.x - v.x);
    }

    public Vector1D subtract(double factor, Vector1D v) {
        return new Vector1D(this.x - factor * v.x);
    }

    public Vector1D negate() {
        return new Vector1D(-this.x);
    }

    public Unit normalize() {
        return Unit.from(this.x);
    }

    public Vector1D multiply(double a) {
        return new Vector1D(a * this.x);
    }

    public double distance(Vector1D v) {
        return Vectors.norm(this.x - v.x);
    }

    public double distanceSq(Vector1D v) {
        return Vectors.normSq(this.x - v.x);
    }

    public double dot(Vector1D v) {
        return this.x * v.x;
    }

    public double angle(Vector1D v) {
        this.getCheckedNorm();
        v.getCheckedNorm();
        double sig1 = Math.signum(this.x);
        double sig2 = Math.signum(v.x);
        return sig1 == sig2 ? 0.0 : Math.PI;
    }

    public Vector1D transform(UnaryOperator<Vector1D> fn) {
        return (Vector1D)fn.apply(this);
    }

    @Override
    public boolean eq(Vector1D vec, DoublePrecisionContext precision) {
        return precision.eq(this.x, vec.x);
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 857;
        }
        return 403 * Double.hashCode(this.x);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Vector1D) {
            Vector1D rhs = (Vector1D)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return Double.compare(this.x, rhs.x) == 0;
        }
        return false;
    }

    public String toString() {
        return SimpleTupleFormat.getDefault().format(this.x);
    }

    public static Vector1D of(double x) {
        return new Vector1D(x);
    }

    public static Vector1D parse(String str) {
        return (Vector1D)SimpleTupleFormat.getDefault().parse(str, Vector1D::new);
    }

    public static Vector1D linearCombination(double a, Vector1D c) {
        return new Vector1D(a * c.x);
    }

    public static Vector1D linearCombination(double a1, Vector1D v1, double a2, Vector1D v2) {
        return new Vector1D(LinearCombination.value((double)a1, (double)v1.x, (double)a2, (double)v2.x));
    }

    public static Vector1D linearCombination(double a1, Vector1D v1, double a2, Vector1D v2, double a3, Vector1D v3) {
        return new Vector1D(LinearCombination.value((double)a1, (double)v1.x, (double)a2, (double)v2.x, (double)a3, (double)v3.x));
    }

    public static Vector1D linearCombination(double a1, Vector1D v1, double a2, Vector1D v2, double a3, Vector1D v3, double a4, Vector1D v4) {
        return new Vector1D(LinearCombination.value((double)a1, (double)v1.x, (double)a2, (double)v2.x, (double)a3, (double)v3.x, (double)a4, (double)v4.x));
    }

    public static final class Unit
    extends Vector1D {
        public static final Unit PLUS = new Unit(1.0);
        public static final Unit MINUS = new Unit(-1.0);

        private Unit(double x) {
            super(x);
        }

        public static Unit from(double x) {
            Vectors.checkedNorm(Vectors.norm(x));
            return x > 0.0 ? PLUS : MINUS;
        }

        public static Unit from(Vector1D v) {
            return v instanceof Unit ? (Unit)v : Unit.from(v.getX());
        }

        @Override
        public double norm() {
            return 1.0;
        }

        @Override
        public double normSq() {
            return 1.0;
        }

        @Override
        public Unit normalize() {
            return this;
        }

        @Override
        public Vector1D withNorm(double mag) {
            return this.multiply(mag);
        }

        @Override
        public Vector1D negate() {
            return this == PLUS ? MINUS : PLUS;
        }
    }
}

