/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.oned;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.AbstractHyperplane;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.oned.OrientedPoints;
import org.apache.commons.geometry.euclidean.oned.Vector1D;

public final class OrientedPoint
extends AbstractHyperplane<Vector1D> {
    private final Vector1D point;
    private final boolean positiveFacing;

    OrientedPoint(Vector1D point, boolean positiveFacing, DoublePrecisionContext precision) {
        super(precision);
        this.point = point;
        this.positiveFacing = positiveFacing;
    }

    public Vector1D getPoint() {
        return this.point;
    }

    public double getLocation() {
        return this.point.getX();
    }

    public Vector1D.Unit getDirection() {
        return this.positiveFacing ? Vector1D.Unit.PLUS : Vector1D.Unit.MINUS;
    }

    public boolean isPositiveFacing() {
        return this.positiveFacing;
    }

    public OrientedPoint reverse() {
        return new OrientedPoint(this.point, !this.positiveFacing, this.getPrecision());
    }

    public OrientedPoint transform(Transform<Vector1D> transform) {
        Vector1D transformedDir;
        Vector1D transformedPoint = (Vector1D)transform.apply((Object)this.point);
        if (this.point.isInfinite()) {
            Vector1D transformedZero = (Vector1D)transform.apply((Object)Vector1D.ZERO);
            Vector1D transformedZeroDir = (Vector1D)transform.apply((Object)this.getDirection());
            transformedDir = transformedZero.vectorTo(transformedZeroDir);
        } else {
            Vector1D transformedPointPlusDir = (Vector1D)transform.apply((Object)this.point.add(this.getDirection()));
            transformedDir = transformedPoint.vectorTo(transformedPointPlusDir);
        }
        return OrientedPoints.fromPointAndDirection(transformedPoint, transformedDir, this.getPrecision());
    }

    public double offset(Vector1D pt) {
        return this.offset(pt.getX());
    }

    public double offset(double location) {
        double delta = location - this.point.getX();
        return this.positiveFacing ? delta : -delta;
    }

    public HyperplaneLocation classify(Vector1D pt) {
        return this.classify(pt.getX());
    }

    public HyperplaneLocation classify(double location) {
        double offsetValue = this.offset(location);
        int cmp = this.getPrecision().sign(offsetValue);
        if (cmp > 0) {
            return HyperplaneLocation.PLUS;
        }
        if (cmp < 0) {
            return HyperplaneLocation.MINUS;
        }
        return HyperplaneLocation.ON;
    }

    public boolean similarOrientation(Hyperplane<Vector1D> other) {
        return this.positiveFacing == ((OrientedPoint)other).positiveFacing;
    }

    public Vector1D project(Vector1D pt) {
        return this.point;
    }

    public HyperplaneConvexSubset<Vector1D> span() {
        return new OrientedPointConvexSubset(this);
    }

    public boolean eq(OrientedPoint other, DoublePrecisionContext precision) {
        return this.point.eq(other.point, precision) && this.positiveFacing == other.positiveFacing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.point);
        result = 31 * result + Boolean.hashCode(this.positiveFacing);
        result = 31 * result + Objects.hashCode(this.getPrecision());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrientedPoint)) {
            return false;
        }
        OrientedPoint other = (OrientedPoint)((Object)obj);
        return Objects.equals(this.point, other.point) && this.positiveFacing == other.positiveFacing && Objects.equals(this.getPrecision(), other.getPrecision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName()).append("[point= ").append(this.point).append(", direction= ").append(this.getDirection()).append(']');
        return sb.toString();
    }

    private static class OrientedPointConvexSubset
    implements HyperplaneConvexSubset<Vector1D> {
        private final OrientedPoint hyperplane;

        OrientedPointConvexSubset(OrientedPoint hyperplane) {
            this.hyperplane = hyperplane;
        }

        public OrientedPoint getHyperplane() {
            return this.hyperplane;
        }

        public boolean isFull() {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isInfinite() {
            return false;
        }

        public boolean isFinite() {
            return true;
        }

        public double getSize() {
            return 0.0;
        }

        public Vector1D getCentroid() {
            return this.hyperplane.getPoint();
        }

        public RegionLocation classify(Vector1D point) {
            if (this.hyperplane.contains(point)) {
                return RegionLocation.BOUNDARY;
            }
            return RegionLocation.OUTSIDE;
        }

        public Vector1D closest(Vector1D point) {
            return this.hyperplane.project(point);
        }

        public Split<OrientedPointConvexSubset> split(Hyperplane<Vector1D> splitter) {
            HyperplaneLocation side = splitter.classify((Point)this.hyperplane.getPoint());
            OrientedPointConvexSubset minus = null;
            OrientedPointConvexSubset plus = null;
            if (side == HyperplaneLocation.MINUS) {
                minus = this;
            } else if (side == HyperplaneLocation.PLUS) {
                plus = this;
            }
            return new Split((Object)minus, (Object)plus);
        }

        public List<OrientedPointConvexSubset> toConvex() {
            return Collections.singletonList(this);
        }

        public OrientedPointConvexSubset transform(Transform<Vector1D> transform) {
            return new OrientedPointConvexSubset(this.getHyperplane().transform(transform));
        }

        public OrientedPointConvexSubset reverse() {
            return new OrientedPointConvexSubset(this.hyperplane.reverse());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append("[hyperplane= ").append((Object)this.hyperplane).append(']');
            return sb.toString();
        }
    }
}

