/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.internal;

import org.apache.commons.geometry.core.Vector;
import org.apache.commons.numbers.arrays.SafeNorm;

public final class Vectors {
    private Vectors() {
    }

    public static boolean isRealNonZero(double value) {
        return Double.isFinite(value) && value != 0.0;
    }

    public static double checkedNorm(double norm) {
        if (!Vectors.isRealNonZero(norm)) {
            throw new IllegalArgumentException("Illegal norm: " + norm);
        }
        return norm;
    }

    public static double checkedNorm(Vector<?> vec) {
        return Vectors.checkedNorm(vec.norm());
    }

    public static <V extends Vector<V>> V tryNormalize(V vec) {
        double norm = vec.norm();
        if (Vectors.isRealNonZero(norm)) {
            return (V)vec.normalize();
        }
        return null;
    }

    public static double norm(double x) {
        return Math.abs(x);
    }

    public static double norm(double x1, double x2) {
        return Math.hypot(x1, x2);
    }

    public static double norm(double x1, double x2, double x3) {
        return SafeNorm.value((double[])new double[]{x1, x2, x3});
    }

    public static double normSq(double x) {
        return x * x;
    }

    public static double normSq(double x1, double x2) {
        return x1 * x1 + x2 * x2;
    }

    public static double normSq(double x1, double x2, double x3) {
        return x1 * x1 + x2 * x2 + x3 * x3;
    }
}

